
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_check_password_srp import TypeInputCheckPasswordSRP
    from ...types.account.password_input_settings import TypeAccountPasswordInputSettings


class UpdatePasswordSettings(TLRequest[bool]):
    """
    Set a new 2FA password

    Raises:
        `400`EmailInvalidError: The specified email is invalid.
        `400`EmailUnconfirmedError: The provided email isn't confirmed, {length} is the length of the verification code that was just sent to the email: use [account.verifyEmail](https://core.telegram.org/method/account.verifyEmail) to enter the received verification code and enable the recovery email.
        `400`EmailUnconfirmedError: The provided email isn't confirmed, {length} is the length of the verification code that was just sent to the email: use [account.verifyEmail](https://core.telegram.org/method/account.verifyEmail) to enter the received verification code and enable the recovery email.
        `400`NewSaltInvalidError: The new salt is invalid.
        `400`NewSettingsEmptyError: No password is set on the current account, and no new password was specified in `new_settings`.
        `400`NewSettingsInvalidError: The new password settings are invalid.
        `400`PasswordHashInvalidError: The provided password hash is invalid.
        `400`SrpIdInvalidError: Invalid SRP ID provided.
        `400`SrpPasswordChangedError: Password has changed.

    """

    _id = 0XA59B102F
    _result_id = 0X43B904E1

    def __init__(
        self,
        password: 'TypeInputCheckPasswordSRP',
        new_settings: 'TypeAccountPasswordInputSettings'
    ):

        """
        Set a new 2FA password

        Args:
            password ('TypeInputCheckPasswordSRP'): The old password (see [SRP](https://core.telegram.org/api/srp))
            new_settings ('TypeAccountPasswordInputSettings'): The new password (see [SRP](https://core.telegram.org/api/srp))
        """

        self.password = password
        self.new_settings = new_settings

    def to_bytes(self, boxed: bool=True):
        with Writer(b'/\x10\x9b\xa5' if boxed else b'') as writer:
            writer.object(
                self.password,
                group_id=0X9F1A3F43
            )
            writer.object(
                self.new_settings,
                group_id=0X59FEE6C
            )

            return writer.getvalue()