
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.auth.sent_code import TypeAuthSentCode


class ResendCode(TLRequest[TypeAuthSentCode]):
    """
    Resend the login code via another medium, the phone code type is determined by the return value of the previous auth.sendCode/auth.resendCode: see [login](https://core.telegram.org/api/auth) for more info.

    Raises:
        `400`PhoneCodeEmptyError: phone_code is missing.
        `400`PhoneCodeExpiredError: The phone code you provided has expired.
        `400`PhoneCodeHashEmptyError: phone_code_hash is missing.
        `406`PhoneNumberInvalidError: The phone number is invalid.
        `406`SendCodeUnavailableError: Returned when all available options for this type of number were already used (e.g. flash-call, then SMS, then this error might be returned to trigger a second resend).

    """

    _id = 0XCAE47523
    _result_id = 0X8F0C24F5

    def __init__(
        self,
        phone_number: str,
        phone_code_hash: str,
        reason: Optional[str] = None
    ):

        """
        Resend the login code via another medium, the phone code type is determined by the return value of the previous auth.sendCode/auth.resendCode: see [login](https://core.telegram.org/api/auth) for more info.

        Args:
            phone_number (str): The phone number
            phone_code_hash (str): The phone code hash obtained from [auth.sendCode](https://core.telegram.org/method/auth.sendCode)
            reason (Optional[str], optional): Official clients only, used if the device integrity verification failed, and no secret could be obtained to invoke [auth.requestFirebaseSms](https://core.telegram.org/method/auth.requestFirebaseSms): in this case, the device integrity verification failure reason must be passed here.
        """

        self.phone_number = phone_number
        self.phone_code_hash = phone_code_hash
        self.reason = reason

    def to_bytes(self, boxed: bool=True):
        with Writer(b'#u\xe4\xca' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.phone_number)
                writer.string(self.phone_code_hash)

                if flags(self.reason, 0):
                    writer.string(self.reason)

            return writer.getvalue()