
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.auth.authorization import TypeAuthAuthorization


if TYPE_CHECKING:
    from ...types.email_verification import TypeEmailVerification


class SignIn(TLRequest[TypeAuthAuthorization]):
    """
    Signs in a user with a validated phone number.

    Raises:
        `500`AuthRestartError: Internal error (debug info {debug_info}), please repeat the method call.
        `500`SignInFailedError: Failure while signing in.
        `400`PhoneCodeEmptyError: phone_code is missing.
        `400`PhoneCodeExpiredError: The phone code you provided has expired.
        `400`PhoneCodeInvalidError: The provided phone code is invalid.
        `400`PhoneNumberUnoccupiedError: The phone number is not yet being used.
        `406`PhoneNumberInvalidError: The phone number is invalid.
        `406`UpdateAppToLoginError: Please update to the latest version of MadelineProto to login.

    """

    _id = 0X8D52A951
    _result_id = 0X2A654890

    def __init__(
        self,
        phone_number: str,
        phone_code_hash: str,
        phone_code: Optional[str] = None,
        email_verification: Optional['TypeEmailVerification'] = None
    ):

        """
        Signs in a user with a validated phone number.

        Args:
            phone_number (str): Phone number in the international format
            phone_code_hash (str): SMS-message ID, obtained from [auth.sendCode](https://core.telegram.org/method/auth.sendCode)
            phone_code (Optional[str], optional): Valid numerical code from the SMS-message
            email_verification (Optional['TypeEmailVerification'], optional): Email verification code or token
        """

        self.phone_number = phone_number
        self.phone_code_hash = phone_code_hash
        self.phone_code = phone_code
        self.email_verification = email_verification

    def to_bytes(self, boxed: bool=True):
        with Writer(b'Q\xa9R\x8d' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.phone_number)
                writer.string(self.phone_code_hash)

                if flags(self.phone_code, 0):
                    writer.string(self.phone_code)

                if flags(self.email_verification, 1):
                    writer.object(
                        self.email_verification,
                        group_id=0X4D88339D
                    )

            return writer.getvalue()