
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_channel import TypeInputChannel


class ReorderPinnedForumTopics(TLRequest[TypeUpdates]):
    """
    Reorder pinned forum topics

    Raises:
        `400`ChannelInvalidError: The provided channel is invalid.

    """

    _id = 0X2950A18F
    _result_id = 0XD68D29C0

    def __init__(
        self,
        channel: 'TypeInputChannel',
        order: List[int],
        force: bool = False
    ):

        """
        Reorder pinned forum topics

        Args:
            channel ('TypeInputChannel'): Supergroup ID
            order (List[int]): [Topic IDs](https://core.telegram.org/api/forum)
            force (bool, optional): If not set, the order of only the topics present both server-side and in order will be changed (i.e. mentioning topics not pinned server-side in order will not pin them, and not mentioning topics pinned server-side will not unpin them).  If set, the entire server-side pinned topic list will be replaced with order (i.e. mentioning topics not pinned server-side in order will pin them, and not mentioning topics pinned server-side will unpin them)
        """

        self.channel = channel
        self.order = order
        self.force = force

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x8f\xa1P)' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.force, 0)
                writer.object(
                    self.channel,
                    group_id=0X42691CEF
                )
                writer.vector(
                    self.order,
                    writer.int
                )

            return writer.getvalue()