
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_channel import TypeInputChannel


class ToggleSignatures(TLRequest[TypeUpdates]):
    """
    Enable/disable message signatures in channels

    Raises:
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`ChatIdInvalidError: The provided chat id is invalid.
        `400`ChatNotModifiedError: No changes were made to chat information because the new information you passed is identical to the current information.

    """

    _id = 0X418D549C
    _result_id = 0XD68D29C0

    def __init__(
        self,
        channel: 'TypeInputChannel',
        signatures_enabled: bool = False,
        profiles_enabled: bool = False
    ):

        """
        Enable/disable message signatures in channels

        Args:
            channel ('TypeInputChannel'): Channel
            signatures_enabled (bool, optional): If set, enables message signatures.
            profiles_enabled (bool, optional): If set, messages from channel admins will link to their profiles, just like for group messages: can only be set if the signatures_enabled flag is set.
        """

        self.channel = channel
        self.signatures_enabled = signatures_enabled
        self.profiles_enabled = profiles_enabled

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9cT\x8dA' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.signatures_enabled, 0)
                flags(self.profiles_enabled, 1)
                writer.object(
                    self.channel,
                    group_id=0X42691CEF
                )

            return writer.getvalue()