
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.affected_history import TypeMessagesAffectedHistory


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class DeleteSavedHistory(TLRequest[TypeMessagesAffectedHistory]):
    """
    Deletes messages forwarded from a specific peer to [saved messages](https://core.telegram.org/api/saved-messages).

    Raises:
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0X4DC5085F
    _result_id = 0XC038BDBA

    def __init__(
        self,
        peer: 'TypeInputPeer',
        max_id: int,
        parent_peer: Optional['TypeInputPeer'] = None,
        min_date: Optional[int] = None,
        max_date: Optional[int] = None
    ):

        """
        Deletes messages forwarded from a specific peer to [saved messages](https://core.telegram.org/api/saved-messages).

        Args:
            peer ('TypeInputPeer'): Peer, whose messages will be deleted from [saved messages](https://core.telegram.org/api/saved-messages)
            max_id (int): Maximum ID of message to delete
            parent_peer (Optional['TypeInputPeer'], optional): ...
            min_date (Optional[int], optional): Delete all messages newer than this UNIX timestamp
            max_date (Optional[int], optional): Delete all messages older than this UNIX timestamp
        """

        self.peer = peer
        self.max_id = max_id
        self.parent_peer = parent_peer
        self.min_date = min_date
        self.max_date = max_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'_\x08\xc5M' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.parent_peer, 0):
                    writer.object(
                        self.parent_peer,
                        group_id=0X995DB9DF
                    )
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.int(self.max_id)

                if flags(self.min_date, 2):
                    writer.int(self.min_date)

                if flags(self.max_date, 3):
                    writer.int(self.max_date)

            return writer.getvalue()