
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.chat_invite_importers import TypeMessagesChatInviteImporters


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_user import TypeInputUser


class GetChatInviteImporters(TLRequest[TypeMessagesChatInviteImporters]):
    """
    Get info about the users that joined the chat using a specific chat invite

    Raises:
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`InviteHashExpiredError: The invite link has expired.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`SearchWithLinkNotSupportedError: You cannot provide a search query and an invite link at the same time.
        `403`ChatWriteForbiddenError: You can't write in this chat.

    """

    _id = 0XDF04DD4E
    _result_id = 0X1C725BCB

    def __init__(
        self,
        peer: 'TypeInputPeer',
        offset_date: int,
        offset_user: 'TypeInputUser',
        limit: int,
        requested: bool = False,
        subscription_expired: bool = False,
        link: Optional[str] = None,
        q: Optional[str] = None
    ):

        """
        Get info about the users that joined the chat using a specific chat invite

        Args:
            peer ('TypeInputPeer'): Chat
            offset_date (int): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
            offset_user ('TypeInputUser'): User ID for [pagination](https://core.telegram.org/api/offsets): if set, offset_date must also be set.
            limit (int): Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
            requested (bool, optional): If set, only returns info about users with pending [join requests](https://core.telegram.org/api/invites#join-requests)
            subscription_expired (bool, optional): Set this flag if the link is a [Telegram Star subscription link](https://core.telegram.org/api/stars#star-subscriptions) and only members with already expired subscription must be returned.
            link (Optional[str], optional): Invite link
            q (Optional[str], optional): Search for a user in the pending [join requests](https://core.telegram.org/api/invites#join-requests) list: only available when the requested flag is set, cannot be used together with a specific link.
        """

        self.peer = peer
        self.offset_date = offset_date
        self.offset_user = offset_user
        self.limit = limit
        self.requested = requested
        self.subscription_expired = subscription_expired
        self.link = link
        self.q = q

    def to_bytes(self, boxed: bool=True):
        with Writer(b'N\xdd\x04\xdf' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.requested, 0)
                flags(self.subscription_expired, 3)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )

                if flags(self.link, 1):
                    writer.string(self.link)

                if flags(self.q, 2):
                    writer.string(self.q)
                writer.int(self.offset_date)
                writer.object(
                    self.offset_user,
                    group_id=0XB628962F
                )
                writer.int(self.limit)

            return writer.getvalue()