
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.exported_chat_invites import TypeMessagesExportedChatInvites


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_user import TypeInputUser


class GetExportedChatInvites(TLRequest[TypeMessagesExportedChatInvites]):
    """
    Get info about the chat invites of a specific chat

    Raises:
        `400`AdminIdInvalidError: The specified admin ID is invalid.
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `403`ChatWriteForbiddenError: You can't write in this chat.

    """

    _id = 0XA2B5A3F6
    _result_id = 0XA5F3E91C

    def __init__(
        self,
        peer: 'TypeInputPeer',
        admin_id: 'TypeInputUser',
        limit: int,
        revoked: bool = False,
        offset_date: Optional[int] = None,
        offset_link: Optional[str] = None
    ):

        """
        Get info about the chat invites of a specific chat

        Args:
            peer ('TypeInputPeer'): Chat
            admin_id ('TypeInputUser'): Whether to only fetch chat invites from this admin
            limit (int): Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
            revoked (bool, optional): Whether to fetch revoked chat invites
            offset_date (Optional[int], optional): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
            offset_link (Optional[str], optional): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
        """

        self.peer = peer
        self.admin_id = admin_id
        self.limit = limit
        self.revoked = revoked
        self.offset_date = offset_date
        self.offset_link = offset_link

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf6\xa3\xb5\xa2' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.revoked, 3)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.object(
                    self.admin_id,
                    group_id=0XB628962F
                )

                if flags(self.offset_date, 2):
                    writer.int(self.offset_date)

                if flags(self.offset_link, 2):
                    writer.string(self.offset_link)
                writer.int(self.limit)

            return writer.getvalue()