
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.search_results_calendar import TypeMessagesSearchResultsCalendar


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.messages_filter import TypeMessagesFilter


class GetSearchResultsCalendar(TLRequest[TypeMessagesSearchResultsCalendar]):
    """
    Returns information about the next messages of the specified type in the chat split by days.

    Raises:
        `400`FilterNotSupportedError: The specified filter cannot be used in this context.
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0X6AA3F6BD
    _result_id = 0XB3425669

    def __init__(
        self,
        peer: 'TypeInputPeer',
        filter: 'TypeMessagesFilter',
        offset_id: int,
        offset_date: int,
        saved_peer_id: Optional['TypeInputPeer'] = None
    ):

        """
        Returns information about the next messages of the specified type in the chat split by days.

        Args:
            peer ('TypeInputPeer'): Peer where to search
            filter ('TypeMessagesFilter'): Message filter, [inputMessagesFilterEmpty](https://core.telegram.org/constructor/inputMessagesFilterEmpty), [inputMessagesFilterMyMentions](https://core.telegram.org/constructor/inputMessagesFilterMyMentions) filters are not supported by this method.
            offset_id (int): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
            offset_date (int): [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
            saved_peer_id (Optional['TypeInputPeer'], optional): Search within the [saved message dialog](https://core.telegram.org/api/saved-messages) with this ID.
        """

        self.peer = peer
        self.filter = filter
        self.offset_id = offset_id
        self.offset_date = offset_date
        self.saved_peer_id = saved_peer_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xbd\xf6\xa3j' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )

                if flags(self.saved_peer_id, 2):
                    writer.object(
                        self.saved_peer_id,
                        group_id=0X995DB9DF
                    )
                writer.object(
                    self.filter,
                    group_id=0X8CDA33F
                )
                writer.int(self.offset_id)
                writer.int(self.offset_date)

            return writer.getvalue()