
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class HideAllChatJoinRequests(TLRequest[TypeUpdates]):
    """
    Dismiss or approve all [join requests](https://core.telegram.org/api/invites#join-requests) related to a specific chat or channel.

    Raises:
        `400`ChannelsTooMuchError: You have joined too many channels/supergroups.
        `400`ChannelInvalidError: The provided channel is invalid.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`HideRequesterMissingError: The join request was missing or was already handled.
        `400`InviteHashExpiredError: The invite link has expired.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`UserChannelsTooMuchError: One of the users you tried to add is already in too many channels/supergroups.
        `403`ChatWriteForbiddenError: You can't write in this chat.

    """

    _id = 0XE085F4EA
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        approved: bool = False,
        link: Optional[str] = None
    ):

        """
        Dismiss or approve all [join requests](https://core.telegram.org/api/invites#join-requests) related to a specific chat or channel.

        Args:
            peer ('TypeInputPeer'): The chat or channel
            approved (bool, optional): Whether to dismiss or approve all chat [join requests](https://core.telegram.org/api/invites#join-requests)
            link (Optional[str], optional): Only dismiss or approve [join requests](https://core.telegram.org/api/invites#join-requests) initiated using this invite link
        """

        self.peer = peer
        self.approved = approved
        self.link = link

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xea\xf4\x85\xe0' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.approved, 0)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )

                if flags(self.link, 1):
                    writer.string(self.link)

            return writer.getvalue()