
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_user import TypeInputUser


class HideChatJoinRequest(TLRequest[TypeUpdates]):
    """
    Dismiss or approve a chat [join request](https://core.telegram.org/api/invites#join-requests) related to a specific chat or channel.

    **Bots can use this method**

    Raises:
        `400`ChannelsTooMuchError: You have joined too many channels/supergroups.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`HideRequesterMissingError: The join request was missing or was already handled.
        `400`InputUserDeactivatedError: The specified user was deleted.
        `400`MsgIdInvalidError: Invalid message ID provided.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`UserAlreadyParticipantError: The user is already in the group.
        `400`UserIdInvalidError: The provided user ID is invalid.
        `403`ChatWriteForbiddenError: You can't write in this chat.
        `403`UserChannelsTooMuchError: One of the users you tried to add is already in too many channels/supergroups.

    """

    _id = 0X7FE7E815
    _result_id = 0XD68D29C0

    def __init__(
        self,
        peer: 'TypeInputPeer',
        user_id: 'TypeInputUser',
        approved: bool = False
    ):

        """
        Dismiss or approve a chat [join request](https://core.telegram.org/api/invites#join-requests) related to a specific chat or channel.

        **Bots can use this method**

        Args:
            peer ('TypeInputPeer'): The chat or channel
            user_id ('TypeInputUser'): The user whose [join request](https://core.telegram.org/api/invites#join-requests) should be dismissed or approved
            approved (bool, optional): Whether to dismiss or approve the chat [join request](https://core.telegram.org/api/invites#join-requests)
        """

        self.peer = peer
        self.user_id = user_id
        self.approved = approved

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x15\xe8\xe7\x7f' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.approved, 0)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.object(
                    self.user_id,
                    group_id=0XB628962F
                )

            return writer.getvalue()