
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.payments.suggested_star_ref_bots import TypePaymentsSuggestedStarRefBots


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class GetSuggestedStarRefBots(TLRequest[TypePaymentsSuggestedStarRefBots]):
    """
    Obtain a list of suggested [mini apps](https://core.telegram.org/api/bots/webapps) with available [affiliate programs](https://core.telegram.org/api/bots/referrals)

    Raises:
        `403`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0XD6B48F7
    _result_id = 0XD7BB8E42

    def __init__(
        self,
        peer: 'TypeInputPeer',
        offset: str,
        limit: int,
        order_by_revenue: bool = False,
        order_by_date: bool = False
    ):

        """
        Obtain a list of suggested [mini apps](https://core.telegram.org/api/bots/webapps) with available [affiliate programs](https://core.telegram.org/api/bots/referrals)

        Args:
            peer ('TypeInputPeer'): The peer that will become the affiliate: star commissions will be transferred to this peer's star balance.
            offset (str): Offset for pagination, taken from [payments.suggestedStarRefBots](https://core.telegram.org/constructor/payments.suggestedStarRefBots). next_offset, initially empty.
            limit (int): Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
            order_by_revenue (bool, optional): If set, orders results by the expected revenue
            order_by_date (bool, optional): If set, orders results by the creation date of the affiliate program
        """

        self.peer = peer
        self.offset = offset
        self.limit = limit
        self.order_by_revenue = order_by_revenue
        self.order_by_date = order_by_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf7Hk\r' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.order_by_revenue, 0)
                flags(self.order_by_date, 1)
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )
                writer.string(self.offset)
                writer.int(self.limit)

            return writer.getvalue()