
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.input_group_call import TypeInputGroupCall


class EditGroupCallParticipant(TLRequest[TypeUpdates]):
    """
    Edit information about a given group call participant

    Raises:
        `403`GroupcallForbiddenError: The group call has already ended.
        `400`GroupcallInvalidError: The specified group call is invalid.
        `400`ParticipantJoinMissingError: Trying to enable a presentation, when the user hasn't joined the Video Chat with [phone.joinGroupCall](https://core.telegram.org/method/phone.joinGroupCall).
        `400`RaiseHandForbiddenError: You cannot raise your hand.
        `400`UserVolumeInvalidError: The specified user volume is invalid.
        `400`VideoPauseForbiddenError: You cannot pause the video stream.
        `400`VideoStopForbiddenError: You cannot stop the video stream.

    """

    _id = 0XA5273ABF
    _result_id = 0XD68D29C0

    def __init__(
        self,
        call: 'TypeInputGroupCall',
        participant: 'TypeInputPeer',
        muted: bool = False,
        volume: Optional[int] = None,
        raise_hand: bool = False,
        video_stopped: bool = False,
        video_paused: bool = False,
        presentation_paused: bool = False
    ):

        """
        Edit information about a given group call participant

        Args:
            call ('TypeInputGroupCall'): The group call
            participant ('TypeInputPeer'): The group call participant (can also be the user itself)
            muted (bool, optional): Whether to mute or unmute the specified participant
            volume (Optional[int], optional): New volume
            raise_hand (bool, optional): Raise or lower hand
            video_stopped (bool, optional): Start or stop the video stream
            video_paused (bool, optional): Pause or resume the video stream
            presentation_paused (bool, optional): Pause or resume the screen sharing stream
        """

        self.call = call
        self.participant = participant
        self.muted = muted
        self.volume = volume
        self.raise_hand = raise_hand
        self.video_stopped = video_stopped
        self.video_paused = video_paused
        self.presentation_paused = presentation_paused

    def to_bytes(self, boxed: bool=True):
        with Writer(b"\xbf:'\xa5" if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.call,
                    group_id=0XDA9A559A
                )
                writer.object(
                    self.participant,
                    group_id=0X995DB9DF
                )

                if flags(self.muted, 0):
                    writer.object(
                        self.muted,
                        group_id=0X43B904E1
                    )

                if flags(self.volume, 1):
                    writer.int(self.volume)

                if flags(self.raise_hand, 2):
                    writer.object(
                        self.raise_hand,
                        group_id=0X43B904E1
                    )

                if flags(self.video_stopped, 3):
                    writer.object(
                        self.video_stopped,
                        group_id=0X43B904E1
                    )

                if flags(self.video_paused, 4):
                    writer.object(
                        self.video_paused,
                        group_id=0X43B904E1
                    )

                if flags(self.presentation_paused, 5):
                    writer.object(
                        self.presentation_paused,
                        group_id=0X43B904E1
                    )

            return writer.getvalue()