
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.premium.my_boosts import TypePremiumMyBoosts


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer


class ApplyBoost(TLRequest[TypePremiumMyBoosts]):
    """
    Apply one or more [boosts](https://core.telegram.org/api/boost) to a peer.

    Raises:
        `400`BoostsEmptyError: No boost slots were specified.
        `400`PeerIdInvalidError: The provided peer id is invalid.
        `400`SlotsEmptyError: The specified slot list is empty.

    """

    _id = 0X6B7DA746
    _result_id = 0XE8B6B21C

    def __init__(
        self,
        peer: 'TypeInputPeer',
        slots: Optional[List[int]] = None
    ):

        """
        Apply one or more [boosts](https://core.telegram.org/api/boost) to a peer.

        Args:
            peer ('TypeInputPeer'): The peer to boost.
            slots (Optional[List[int]], optional): Which [boost slots](https://core.telegram.org/api/boost) to assign to this peer.
        """

        self.peer = peer
        self.slots = slots

    def to_bytes(self, boxed: bool=True):
        with Writer(b'F\xa7}k' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.slots, 0):
                    writer.vector(
                        self.slots,
                        writer.int
                    )
                writer.object(
                    self.peer,
                    group_id=0X995DB9DF
                )

            return writer.getvalue()