
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer
from ...types.messages.sticker_set import TypeMessagesStickerSet


if TYPE_CHECKING:
    from ...types.mask_coords import TypeMaskCoords
    from ...types.input_document import TypeInputDocument


class ChangeSticker(TLRequest[TypeMessagesStickerSet]):
    """
    Update the keywords, emojis or [mask coordinates](https://core.telegram.org/api/stickers#mask-stickers) of a sticker.

    **Bots can use this method**

    Raises:
        `400`StickerInvalidError: The provided sticker is invalid.

    """

    _id = 0XF5537EBC
    _result_id = 0X5CC84E96

    def __init__(
        self,
        sticker: 'TypeInputDocument',
        emoji: Optional[str] = None,
        mask_coords: Optional['TypeMaskCoords'] = None,
        keywords: Optional[str] = None
    ):

        """
        Update the keywords, emojis or [mask coordinates](https://core.telegram.org/api/stickers#mask-stickers) of a sticker.

        **Bots can use this method**

        Args:
            sticker ('TypeInputDocument'): The sticker
            emoji (Optional[str], optional): If set, updates the emoji list associated to the sticker
            mask_coords (Optional['TypeMaskCoords'], optional): If set, updates the [mask coordinates](https://core.telegram.org/api/stickers#mask-stickers)
            keywords (Optional[str], optional): If set, updates the sticker keywords (separated by commas). Can't be provided for mask stickers.
        """

        self.sticker = sticker
        self.emoji = emoji
        self.mask_coords = mask_coords
        self.keywords = keywords

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xbc~S\xf5' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.sticker,
                    group_id=0X84313E
                )

                if flags(self.emoji, 0):
                    writer.string(self.emoji)

                if flags(self.mask_coords, 1):
                    writer.object(
                        self.mask_coords,
                        group_id=0X32852A28
                    )

                if flags(self.keywords, 2):
                    writer.string(self.keywords)

            return writer.getvalue()