
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Optional
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..peer import TypePeer
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..message_entity import TypeMessageEntity
    from ....gadgets.byteutils import Reader


class ResolvedBusinessChatLinks(TLObject, family='TypeAccountResolvedBusinessChatLinks'):
    """
    Contains info about a single resolved [business chat deep link](https://core.telegram.org/api/business#business-chat-links).
    """

    _id = 0X9A23AF21
    _group_id = 0X8C7CEE52

    def __init__(
        self,
        peer: 'TypePeer',
        message: str,
        chats: List['TypeChat'],
        users: List['TypeUser'],
        entities: Optional[List['TypeMessageEntity']] = None
    ):

        """
        Contains info about a single resolved [business chat deep link](https://core.telegram.org/api/business#business-chat-links).

        Args:
            peer ('TypePeer'): Destination peer
            message (str): Message to pre-fill in the message input field.
            chats (List['TypeChat']): Mentioned chats
            users (List['TypeUser']): Mentioned users
            entities (Optional[List['TypeMessageEntity']], optional): [Message entities for styled text](https://core.telegram.org/api/entities)
        """

        self.peer = peer
        self.message = message
        self.chats = chats
        self.users = users
        self.entities = entities

    def to_bytes(self, boxed: bool=True):
        with Writer(b'!\xaf#\x9a' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )
                writer.string(self.message)

                if flags(self.entities, 0):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        message_ = reader.string()
        entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(0) else None
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            peer=peer_,
            message=message_,
            chats=chats_,
            users=users_,
            entities=entities_
        )

TypeAccountResolvedBusinessChatLinks = ResolvedBusinessChatLinks