
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class BotAppSettings(TLObject, family='TypeBotAppSettings'):
    """
    [Mini app](https://core.telegram.org/api/bots/webapps) settings
    """

    _id = 0XC99B1950
    _group_id = 0X95652DC8

    def __init__(
        self,
        placeholder_path: Optional[bytes] = None,
        background_color: Optional[int] = None,
        background_dark_color: Optional[int] = None,
        header_color: Optional[int] = None,
        header_dark_color: Optional[int] = None
    ):

        """
        [Mini app](https://core.telegram.org/api/bots/webapps) settings

        Args:
            placeholder_path (Optional[bytes], optional): SVG placeholder logo, compressed using the same format used for [vector thumbnails](https://core.telegram.org/api/files#vector-thumbnails).
            background_color (Optional[int], optional): Default light mode background color
            background_dark_color (Optional[int], optional): Default dark mode background color
            header_color (Optional[int], optional): Default light mode header color
            header_dark_color (Optional[int], optional): Default dark mode header color
        """

        self.placeholder_path = placeholder_path
        self.background_color = background_color
        self.background_dark_color = background_dark_color
        self.header_color = header_color
        self.header_dark_color = header_dark_color

    def to_bytes(self, boxed: bool=True):
        with Writer(b'P\x19\x9b\xc9' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.placeholder_path, 0):
                    writer.bytes(self.placeholder_path)

                if flags(self.background_color, 1):
                    writer.int(self.background_color)

                if flags(self.background_dark_color, 2):
                    writer.int(self.background_dark_color)

                if flags(self.header_color, 3):
                    writer.int(self.header_color)

                if flags(self.header_dark_color, 4):
                    writer.int(self.header_dark_color)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        placeholder_path_ = (
            reader.bytes()
            if flags(0) else None
        )

        background_color_ = (
            reader.int()
            if flags(1) else None
        )

        background_dark_color_ = (
            reader.int()
            if flags(2) else None
        )

        header_color_ = (
            reader.int()
            if flags(3) else None
        )

        header_dark_color_ = (
            reader.int()
            if flags(4) else None
        )

        return cls(
            placeholder_path=placeholder_path_,
            background_color=background_color_,
            background_dark_color=background_dark_color_,
            header_color=header_color_,
            header_dark_color=header_dark_color_
        )

TypeBotAppSettings = BotAppSettings