
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class BusinessBotRecipients(TLObject, family='TypeBusinessBotRecipients'):
    """
    Specifies the private chats that a [connected business bot](https://core.telegram.org/api/business#connected-bots) may receive messages and interact with.
    """

    _id = 0XB88CF373
    _group_id = 0XBB9249E9

    def __init__(
        self,
        existing_chats: bool = False,
        new_chats: bool = False,
        contacts: bool = False,
        non_contacts: bool = False,
        exclude_selected: bool = False,
        users: Optional[List[int]] = None,
        exclude_users: Optional[List[int]] = None
    ):

        """
        Specifies the private chats that a [connected business bot](https://core.telegram.org/api/business#connected-bots) may receive messages and interact with.

        Args:
            existing_chats (bool, optional): Selects all existing private chats.
            new_chats (bool, optional): Selects all new private chats.
            contacts (bool, optional): Selects all private chats with contacts.
            non_contacts (bool, optional): Selects all private chats with non-contacts.
            exclude_selected (bool, optional): If set, then all private chats except the ones selected by existing_chats, new_chats, contacts, non_contacts and users are chosen. Note that if this flag is set, any values passed in exclude_users will be merged and moved into users by the server, thus exclude_users will always be empty.
            users (Optional[List[int]], optional): Explicitly selected private chats.
            exclude_users (Optional[List[int]], optional): Identifiers of private chats that are always excluded.
        """

        self.existing_chats = existing_chats
        self.new_chats = new_chats
        self.contacts = contacts
        self.non_contacts = non_contacts
        self.exclude_selected = exclude_selected
        self.users = users
        self.exclude_users = exclude_users

    def to_bytes(self, boxed: bool=True):
        with Writer(b's\xf3\x8c\xb8' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.existing_chats, 0)
                flags(self.new_chats, 1)
                flags(self.contacts, 2)
                flags(self.non_contacts, 3)
                flags(self.exclude_selected, 5)

                if flags(self.users, 4):
                    writer.vector(
                        self.users,
                        writer.long
                    )

                if flags(self.exclude_users, 6):
                    writer.vector(
                        self.exclude_users,
                        writer.long
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        users_ = (
            reader.vector(
                reader.long
            )
            if flags(4) else None
        )

        exclude_users_ = (
            reader.vector(
                reader.long
            )
            if flags(6) else None
        )

        return cls(
            existing_chats=flags(0),
            new_chats=flags(1),
            contacts=flags(2),
            non_contacts=flags(3),
            exclude_selected=flags(5),
            users=users_,
            exclude_users=exclude_users_
        )

TypeBusinessBotRecipients = BusinessBotRecipients