
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class ChatInviteImporter(TLObject, family='TypeChatInviteImporter'):
    """
    When and which user joined the chat using a chat invite
    """

    _id = 0X8C5ADFD9
    _group_id = 0XAB196C96

    def __init__(
        self,
        user_id: int,
        date: int,
        requested: bool = False,
        via_chatlist: bool = False,
        about: Optional[str] = None,
        approved_by: Optional[int] = None
    ):

        """
        When and which user joined the chat using a chat invite

        Args:
            user_id (int): The user
            date (int): When did the user join
            requested (bool, optional): Whether this user currently has a pending [join request](https://core.telegram.org/api/invites#join-requests)
            via_chatlist (bool, optional): The participant joined by importing a [chat folder deep link](https://core.telegram.org/api/links#chat-folder-links).
            about (Optional[str], optional): For users with pending requests, contains bio of the user that requested to join
            approved_by (Optional[int], optional): The administrator that approved the [join request](https://core.telegram.org/api/invites#join-requests) of the user
        """

        self.user_id = user_id
        self.date = date
        self.requested = requested
        self.via_chatlist = via_chatlist
        self.about = about
        self.approved_by = approved_by

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd9\xdfZ\x8c' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.requested, 0)
                flags(self.via_chatlist, 3)
                writer.long(self.user_id)
                writer.int(self.date)

                if flags(self.about, 2):
                    writer.string(self.about)

                if flags(self.approved_by, 1):
                    writer.long(self.approved_by)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        user_id_ = reader.long()
        date_ = reader.int()
        about_ = (
            reader.string()
            if flags(2) else None
        )

        approved_by_ = (
            reader.long()
            if flags(1) else None
        )

        return cls(
            user_id=user_id_,
            date=date_,
            requested=flags(0),
            via_chatlist=flags(3),
            about=about_,
            approved_by=approved_by_
        )

TypeChatInviteImporter = ChatInviteImporter