
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .emoji_keyword import TypeEmojiKeyword
    from ...gadgets.byteutils import Reader


class EmojiKeywordsDifference(TLObject, family='TypeEmojiKeywordsDifference'):
    """
    Changes to emoji keywords
    """

    _id = 0X5CC761BD
    _group_id = 0X1761D1BD

    def __init__(
        self,
        lang_code: str,
        from_version: int,
        version: int,
        keywords: List['TypeEmojiKeyword']
    ):

        """
        Changes to emoji keywords

        Args:
            lang_code (str): Language code for keywords
            from_version (int): Previous emoji keyword list version
            version (int): Current version of emoji keyword list
            keywords (List['TypeEmojiKeyword']): Emojis associated to keywords
        """

        self.lang_code = lang_code
        self.from_version = from_version
        self.version = version
        self.keywords = keywords

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xbda\xc7\\' if boxed else b'') as writer:
            writer.string(self.lang_code)
            writer.int(self.from_version)
            writer.int(self.version)
            writer.vector(
                self.keywords,
                lambda value: writer.object(
                    value,
                    group_id=0X6489BB2C
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        lang_code_ = reader.string()
        from_version_ = reader.int()
        version_ = reader.int()
        keywords_ = reader.vector(
            lambda: reader.object(
                group_id=0X6489BB2C
            )
        )

        return cls(
            lang_code=lang_code_,
            from_version=from_version_,
            version=version_,
            keywords=keywords_
        )

TypeEmojiKeywordsDifference = EmojiKeywordsDifference