
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Long, Writer


if TYPE_CHECKING:
    from .encrypted_file import TypeEncryptedFile
    from ...gadgets.byteutils import Reader


class EncryptedMessage(TLObject, family='TypeEncryptedMessage'):
    """
    Encrypted message.
    """

    _id = 0XED18C118
    _group_id = 0XB38C0DC2

    def __init__(
        self,
        chat_id: int,
        date: int,
        bytes: bytes,
        file: 'TypeEncryptedFile',
        random_id: int = None
    ):

        """
        Encrypted message.

        Args:
            chat_id (int): ID of encrypted chat
            date (int): Date of sending
            bytes (bytes): TL-serialization of [DecryptedMessage](https://core.telegram.org/type/DecryptedMessage) type, encrypted with the key created at chat initialization
            file ('TypeEncryptedFile'): Attached encrypted file
            random_id (int, optional): Random message ID, assigned by the author of message
        """

        self.chat_id = chat_id
        self.date = date
        self.bytes = bytes
        self.file = file
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x18\xc1\x18\xed' if boxed else b'') as writer:
            writer.long(self.random_id)
            writer.int(self.chat_id)
            writer.int(self.date)
            writer.bytes(self.bytes)
            writer.object(
                self.file,
                group_id=0X77918D96
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        random_id_ = reader.long()
        chat_id_ = reader.int()
        date_ = reader.int()
        bytes_ = reader.bytes()
        file_ = reader.object(
            group_id=0X77918D96
        )

        return cls(
            random_id=random_id_,
            chat_id=chat_id_,
            date=date_,
            bytes=bytes_,
            file=file_
        )

class EncryptedMessageService(TLObject, family='TypeEncryptedMessage'):
    """
    Encrypted service message
    """

    _id = 0X23734B06
    _group_id = 0XB38C0DC2

    def __init__(
        self,
        chat_id: int,
        date: int,
        bytes: bytes,
        random_id: int = None
    ):

        """
        Encrypted service message

        Args:
            chat_id (int): ID of encrypted chat
            date (int): Date of sending
            bytes (bytes): TL-serialization of the [DecryptedMessage](https://core.telegram.org/type/DecryptedMessage) type, encrypted with the key created at chat initialization
            random_id (int, optional): Random message ID, assigned by the author of message
        """

        self.chat_id = chat_id
        self.date = date
        self.bytes = bytes
        self.random_id = Long() if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x06Ks#' if boxed else b'') as writer:
            writer.long(self.random_id)
            writer.int(self.chat_id)
            writer.int(self.date)
            writer.bytes(self.bytes)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        random_id_ = reader.long()
        chat_id_ = reader.int()
        date_ = reader.int()
        bytes_ = reader.bytes()

        return cls(
            random_id=random_id_,
            chat_id=chat_id_,
            date=date_,
            bytes=bytes_
        )

TypeEncryptedMessage = Union[
    EncryptedMessage,
    EncryptedMessageService
]