
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from .draft_message import TypeDraftMessage
    from ...gadgets.byteutils import Reader
    from .peer_notify_settings import TypePeerNotifySettings


class ForumTopicDeleted(TLObject, family='TypeForumTopic'):
    """
    Represents a deleted forum topic.
    """

    _id = 0X23F109B
    _group_id = 0XB926BAD6

    def __init__(
        self,
        id: int
    ):

        """
        Represents a deleted forum topic.

        Args:
            id (int): The ID of the deleted forum topic.
        """

        self.id = id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9b\x10?\x02' if boxed else b'') as writer:
            writer.int(self.id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.int()

        return cls(
            id=id_
        )

class ForumTopic(TLObject, family='TypeForumTopic'):
    """
    Represents a [forum topic](https://core.telegram.org/api/forum#forum-topics).
    """

    _id = 0X71701DA9
    _group_id = 0XB926BAD6

    def __init__(
        self,
        id: int,
        date: int,
        title: str,
        icon_color: int,
        top_message: int,
        read_inbox_max_id: int,
        read_outbox_max_id: int,
        unread_count: int,
        unread_mentions_count: int,
        unread_reactions_count: int,
        from_id: 'TypePeer',
        notify_settings: 'TypePeerNotifySettings',
        my: bool = False,
        closed: bool = False,
        pinned: bool = False,
        short: bool = False,
        hidden: bool = False,
        icon_emoji_id: Optional[int] = None,
        draft: Optional['TypeDraftMessage'] = None
    ):

        """
        Represents a [forum topic](https://core.telegram.org/api/forum#forum-topics).

        Args:
            id (int): [Topic ID](https://core.telegram.org/api/forum#forum-topics)
            date (int): Topic creation date
            title (str): Topic title
            icon_color (int): If no custom emoji icon is specified, specifies the color of the fallback topic icon (RGB), one of 0x6FB9F0, 0xFFD67E, 0xCB86DB, 0x8EEE98, 0xFF93B2, or 0xFB6F5F.
            top_message (int): ID of the last message that was sent to this topic
            read_inbox_max_id (int): Position up to which all incoming messages are read.
            read_outbox_max_id (int): Position up to which all outgoing messages are read.
            unread_count (int): Number of unread messages
            unread_mentions_count (int): Number of [unread mentions](https://core.telegram.org/api/mentions)
            unread_reactions_count (int): Number of unread reactions to messages you sent
            from_id ('TypePeer'): ID of the peer that created the topic
            notify_settings ('TypePeerNotifySettings'): Notification settings
            my (bool, optional): Whether the topic was created by the current user
            closed (bool, optional): Whether the topic is closed (no messages can be sent to it)
            pinned (bool, optional): Whether the topic is pinned
            short (bool, optional): Whether this constructor is a reduced version of the full topic information. If set, only the my, closed, id, date, title, icon_color, icon_emoji_id and from_id parameters will contain valid information. Reduced info is usually only returned in topic-related [admin log events](https://core.telegram.org/api/recent-actions) and in the [messages.channelMessages](https://core.telegram.org/constructor/messages.channelMessages) constructor: if needed, full information can be fetched using [channels.getForumTopicsByID](https://core.telegram.org/method/channels.getForumTopicsByID).
            hidden (bool, optional): Whether the topic is hidden (only valid for the "General" topic, id=1)
            icon_emoji_id (Optional[int], optional): ID of the [custom emoji](https://core.telegram.org/api/custom-emoji) used as topic icon.
            draft (Optional['TypeDraftMessage'], optional): Message [draft](https://core.telegram.org/api/drafts)
        """

        self.id = id
        self.date = date
        self.title = title
        self.icon_color = icon_color
        self.top_message = top_message
        self.read_inbox_max_id = read_inbox_max_id
        self.read_outbox_max_id = read_outbox_max_id
        self.unread_count = unread_count
        self.unread_mentions_count = unread_mentions_count
        self.unread_reactions_count = unread_reactions_count
        self.from_id = from_id
        self.notify_settings = notify_settings
        self.my = my
        self.closed = closed
        self.pinned = pinned
        self.short = short
        self.hidden = hidden
        self.icon_emoji_id = icon_emoji_id
        self.draft = draft

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa9\x1dpq' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.my, 1)
                flags(self.closed, 2)
                flags(self.pinned, 3)
                flags(self.short, 5)
                flags(self.hidden, 6)
                writer.int(self.id)
                writer.int(self.date)
                writer.string(self.title)
                writer.int(self.icon_color)

                if flags(self.icon_emoji_id, 0):
                    writer.long(self.icon_emoji_id)
                writer.int(self.top_message)
                writer.int(self.read_inbox_max_id)
                writer.int(self.read_outbox_max_id)
                writer.int(self.unread_count)
                writer.int(self.unread_mentions_count)
                writer.int(self.unread_reactions_count)
                writer.object(
                    self.from_id,
                    group_id=0XB4DECBCA
                )
                writer.object(
                    self.notify_settings,
                    group_id=0X372BF8CC
                )

                if flags(self.draft, 4):
                    writer.object(
                        self.draft,
                        group_id=0X314F6157
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.int()
        date_ = reader.int()
        title_ = reader.string()
        icon_color_ = reader.int()
        icon_emoji_id_ = (
            reader.long()
            if flags(0) else None
        )

        top_message_ = reader.int()
        read_inbox_max_id_ = reader.int()
        read_outbox_max_id_ = reader.int()
        unread_count_ = reader.int()
        unread_mentions_count_ = reader.int()
        unread_reactions_count_ = reader.int()
        from_id_ = reader.object(
            group_id=0XB4DECBCA
        )

        notify_settings_ = reader.object(
            group_id=0X372BF8CC
        )

        draft_ = (
            reader.object(
                group_id=0X314F6157
            )
            if flags(4) else None
        )

        return cls(
            id=id_,
            date=date_,
            title=title_,
            icon_color=icon_color_,
            top_message=top_message_,
            read_inbox_max_id=read_inbox_max_id_,
            read_outbox_max_id=read_outbox_max_id_,
            unread_count=unread_count_,
            unread_mentions_count=unread_mentions_count_,
            unread_reactions_count=unread_reactions_count_,
            from_id=from_id_,
            notify_settings=notify_settings_,
            my=flags(1),
            closed=flags(2),
            pinned=flags(3),
            short=flags(5),
            hidden=flags(6),
            icon_emoji_id=icon_emoji_id_,
            draft=draft_
        )

TypeForumTopic = Union[
    ForumTopicDeleted,
    ForumTopic
]