
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader
    from .disallowed_gifts_settings import TypeDisallowedGiftsSettings


class GlobalPrivacySettings(TLObject, family='TypeGlobalPrivacySettings'):
    """
    Global privacy settings
    """

    _id = 0XFE41B34F
    _group_id = 0X820E9D53

    def __init__(
        self,
        archive_and_mute_new_noncontact_peers: bool = False,
        keep_archived_unmuted: bool = False,
        keep_archived_folders: bool = False,
        hide_read_marks: bool = False,
        new_noncontact_peers_require_premium: bool = False,
        display_gifts_button: bool = False,
        noncontact_peers_paid_stars: Optional[int] = None,
        disallowed_gifts: Optional['TypeDisallowedGiftsSettings'] = None
    ):

        """
        Global privacy settings

        Args:
            archive_and_mute_new_noncontact_peers (bool, optional): Whether to archive and mute new chats from non-contacts
            keep_archived_unmuted (bool, optional): Whether unmuted chats will be kept in the Archive chat list when they get a new message.
            keep_archived_folders (bool, optional): Whether unmuted chats that are always included or pinned in a [folder](https://core.telegram.org/api/folders), will be kept in the Archive chat list when they get a new message. Ignored if keep_archived_unmuted is set.
            hide_read_marks (bool, optional): If this flag is set, the [inputPrivacyKeyStatusTimestamp](https://core.telegram.org/constructor/inputPrivacyKeyStatusTimestamp) key will also apply to the ability to use [messages.getOutboxReadDate](https://core.telegram.org/method/messages.getOutboxReadDate) on messages sent to us. Meaning, users that cannot see our exact last online date due to the current value of the [inputPrivacyKeyStatusTimestamp](https://core.telegram.org/constructor/inputPrivacyKeyStatusTimestamp) key will receive a 403 USER_PRIVACY_RESTRICTED error when invoking [messages.getOutboxReadDate](https://core.telegram.org/method/messages.getOutboxReadDate) to fetch the exact read date of a message they sent to us. The [userFull](https://core.telegram.org/constructor/userFull). read_dates_private flag will be set for users that have this flag enabled.
            new_noncontact_peers_require_premium (bool, optional): If set, only users that have a premium account, are in our contact list, or already have a private chat with us can write to us; a 403 PRIVACY_PREMIUM_REQUIRED error will be emitted otherwise.  The [userFull](https://core.telegram.org/constructor/userFull). contact_require_premium flag will be set for users that have this flag enabled.  To check whether we can write to a user with this flag enabled, if we haven't yet cached all the required information (for example we don't have the [userFull](https://core.telegram.org/constructor/userFull) or history of all users while displaying the chat list in the sharing UI) the [users.getIsPremiumRequiredToContact](https://core.telegram.org/method/users.getIsPremiumRequiredToContact) method may be invoked, passing the list of users currently visible in the UI, returning a list of booleans that directly specify whether we can or cannot write to each user. This option may be enabled by both non- [Premium](https://core.telegram.org/api/premium) and [Premium](https://core.telegram.org/api/premium) users only if the [new_noncontact_peers_require_premium_without_ownpremium client configuration flag](https://core.telegram.org/api/config#new-noncontact-peers-require-premium-without-ownpremium) is equal to true, otherwise it may be enabled only by [Premium](https://core.telegram.org/api/premium) users and non-Premium users will receive a PREMIUM_ACCOUNT_REQUIRED error when trying to enable this flag.
            display_gifts_button (bool, optional): ...
            noncontact_peers_paid_stars (Optional[int], optional): ...
            disallowed_gifts (Optional['TypeDisallowedGiftsSettings'], optional): ...
        """

        self.archive_and_mute_new_noncontact_peers = archive_and_mute_new_noncontact_peers
        self.keep_archived_unmuted = keep_archived_unmuted
        self.keep_archived_folders = keep_archived_folders
        self.hide_read_marks = hide_read_marks
        self.new_noncontact_peers_require_premium = new_noncontact_peers_require_premium
        self.display_gifts_button = display_gifts_button
        self.noncontact_peers_paid_stars = noncontact_peers_paid_stars
        self.disallowed_gifts = disallowed_gifts

    def to_bytes(self, boxed: bool=True):
        with Writer(b'O\xb3A\xfe' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.archive_and_mute_new_noncontact_peers, 0)
                flags(self.keep_archived_unmuted, 1)
                flags(self.keep_archived_folders, 2)
                flags(self.hide_read_marks, 3)
                flags(self.new_noncontact_peers_require_premium, 4)
                flags(self.display_gifts_button, 7)

                if flags(self.noncontact_peers_paid_stars, 5):
                    writer.long(self.noncontact_peers_paid_stars)

                if flags(self.disallowed_gifts, 6):
                    writer.object(
                        self.disallowed_gifts,
                        group_id=0XC69AFE64
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        noncontact_peers_paid_stars_ = (
            reader.long()
            if flags(5) else None
        )

        disallowed_gifts_ = (
            reader.object(
                group_id=0XC69AFE64
            )
            if flags(6) else None
        )

        return cls(
            archive_and_mute_new_noncontact_peers=flags(0),
            keep_archived_unmuted=flags(1),
            keep_archived_folders=flags(2),
            hide_read_marks=flags(3),
            new_noncontact_peers_require_premium=flags(4),
            display_gifts_button=flags(7),
            noncontact_peers_paid_stars=noncontact_peers_paid_stars_,
            disallowed_gifts=disallowed_gifts_
        )

TypeGlobalPrivacySettings = GlobalPrivacySettings