
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class GroupCallDiscarded(TLObject, family='TypeGroupCall'):
    """
    An ended group call
    """

    _id = 0X7780BCB4
    _group_id = 0X70F5DA49

    def __init__(
        self,
        id: int,
        access_hash: int,
        duration: int
    ):

        """
        An ended group call

        Args:
            id (int): Group call ID
            access_hash (int): Group call access hash
            duration (int): Group call duration
        """

        self.id = id
        self.access_hash = access_hash
        self.duration = duration

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb4\xbc\x80w' if boxed else b'') as writer:
            writer.long(self.id)
            writer.long(self.access_hash)
            writer.int(self.duration)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        access_hash_ = reader.long()
        duration_ = reader.int()

        return cls(
            id=id_,
            access_hash=access_hash_,
            duration=duration_
        )

class GroupCall(TLObject, family='TypeGroupCall'):
    """
    Info about a group call or livestream
    """

    _id = 0X553B0BA1
    _group_id = 0X70F5DA49

    def __init__(
        self,
        id: int,
        access_hash: int,
        participants_count: int,
        unmuted_video_limit: int,
        version: int,
        join_muted: bool = False,
        can_change_join_muted: bool = False,
        join_date_asc: bool = False,
        schedule_start_subscribed: bool = False,
        can_start_video: bool = False,
        record_video_active: bool = False,
        rtmp_stream: bool = False,
        listeners_hidden: bool = False,
        conference: bool = False,
        creator: bool = False,
        title: Optional[str] = None,
        stream_dc_id: Optional[int] = None,
        record_start_date: Optional[int] = None,
        schedule_date: Optional[int] = None,
        unmuted_video_count: Optional[int] = None,
        invite_link: Optional[str] = None
    ):

        """
        Info about a group call or livestream

        Args:
            id (int): Group call ID
            access_hash (int): Group call access hash
            participants_count (int): Participant count
            unmuted_video_limit (int): Maximum number of people allowed to stream video into the call
            version (int): Version
            join_muted (bool, optional): Whether the user should be muted upon joining the call
            can_change_join_muted (bool, optional): Whether the current user can change the value of the join_muted flag using [phone.toggleGroupCallSettings](https://core.telegram.org/method/phone.toggleGroupCallSettings)
            join_date_asc (bool, optional): Specifies the ordering to use when locally sorting by date and displaying in the UI group call participants.
            schedule_start_subscribed (bool, optional): Whether we subscribed to the scheduled call
            can_start_video (bool, optional): Whether you can start streaming video into the call
            record_video_active (bool, optional): Whether the group call is currently being recorded
            rtmp_stream (bool, optional): Whether RTMP streams are allowed
            listeners_hidden (bool, optional): Whether the listeners list is hidden and cannot be fetched using [phone.getGroupParticipants](https://core.telegram.org/method/phone.getGroupParticipants). The phone.groupParticipants.count and groupCall.participants_count counters will still include listeners.
            conference (bool, optional): ...
            creator (bool, optional): ...
            title (Optional[str], optional): Group call title
            stream_dc_id (Optional[int], optional): DC ID to be used for livestream chunks
            record_start_date (Optional[int], optional): When was the recording started
            schedule_date (Optional[int], optional): When is the call scheduled to start
            unmuted_video_count (Optional[int], optional): Number of people currently streaming video into the call
            invite_link (Optional[str], optional): ...
        """

        self.id = id
        self.access_hash = access_hash
        self.participants_count = participants_count
        self.unmuted_video_limit = unmuted_video_limit
        self.version = version
        self.join_muted = join_muted
        self.can_change_join_muted = can_change_join_muted
        self.join_date_asc = join_date_asc
        self.schedule_start_subscribed = schedule_start_subscribed
        self.can_start_video = can_start_video
        self.record_video_active = record_video_active
        self.rtmp_stream = rtmp_stream
        self.listeners_hidden = listeners_hidden
        self.conference = conference
        self.creator = creator
        self.title = title
        self.stream_dc_id = stream_dc_id
        self.record_start_date = record_start_date
        self.schedule_date = schedule_date
        self.unmuted_video_count = unmuted_video_count
        self.invite_link = invite_link

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa1\x0b;U' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.join_muted, 1)
                flags(self.can_change_join_muted, 2)
                flags(self.join_date_asc, 6)
                flags(self.schedule_start_subscribed, 8)
                flags(self.can_start_video, 9)
                flags(self.record_video_active, 11)
                flags(self.rtmp_stream, 12)
                flags(self.listeners_hidden, 13)
                flags(self.conference, 14)
                flags(self.creator, 15)
                writer.long(self.id)
                writer.long(self.access_hash)
                writer.int(self.participants_count)

                if flags(self.title, 3):
                    writer.string(self.title)

                if flags(self.stream_dc_id, 4):
                    writer.int(self.stream_dc_id)

                if flags(self.record_start_date, 5):
                    writer.int(self.record_start_date)

                if flags(self.schedule_date, 7):
                    writer.int(self.schedule_date)

                if flags(self.unmuted_video_count, 10):
                    writer.int(self.unmuted_video_count)
                writer.int(self.unmuted_video_limit)
                writer.int(self.version)

                if flags(self.invite_link, 16):
                    writer.string(self.invite_link)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        id_ = reader.long()
        access_hash_ = reader.long()
        participants_count_ = reader.int()
        title_ = (
            reader.string()
            if flags(3) else None
        )

        stream_dc_id_ = (
            reader.int()
            if flags(4) else None
        )

        record_start_date_ = (
            reader.int()
            if flags(5) else None
        )

        schedule_date_ = (
            reader.int()
            if flags(7) else None
        )

        unmuted_video_count_ = (
            reader.int()
            if flags(10) else None
        )

        unmuted_video_limit_ = reader.int()
        version_ = reader.int()
        invite_link_ = (
            reader.string()
            if flags(16) else None
        )

        return cls(
            id=id_,
            access_hash=access_hash_,
            participants_count=participants_count_,
            unmuted_video_limit=unmuted_video_limit_,
            version=version_,
            join_muted=flags(1),
            can_change_join_muted=flags(2),
            join_date_asc=flags(6),
            schedule_start_subscribed=flags(8),
            can_start_video=flags(9),
            record_video_active=flags(11),
            rtmp_stream=flags(12),
            listeners_hidden=flags(13),
            conference=flags(14),
            creator=flags(15),
            title=title_,
            stream_dc_id=stream_dc_id_,
            record_start_date=record_start_date_,
            schedule_date=schedule_date_,
            unmuted_video_count=unmuted_video_count_,
            invite_link=invite_link_
        )

TypeGroupCall = Union[
    GroupCallDiscarded,
    GroupCall
]