
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Union, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .invoice import TypeInvoice
    from .data_json import TypeDataJSON
    from .reply_markup import TypeReplyMarkup
    from .message_entity import TypeMessageEntity
    from .input_geo_point import TypeInputGeoPoint
    from .input_web_document import TypeInputWebDocument
    from ...gadgets.byteutils import Reader


class InputBotInlineMessageMediaAuto(TLObject, family='TypeInputBotInlineMessage'):
    """
    A media
    """

    _id = 0X3380C786
    _group_id = 0X18FB8A33

    def __init__(
        self,
        message: str,
        invert_media: bool = False,
        entities: Optional[List['TypeMessageEntity']] = None,
        reply_markup: Optional['TypeReplyMarkup'] = None
    ):

        """
        A media

        Args:
            message (str): Caption
            invert_media (bool, optional): If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
            entities (Optional[List['TypeMessageEntity']], optional): [Message entities for styled text](https://core.telegram.org/api/entities)
            reply_markup (Optional['TypeReplyMarkup'], optional): Inline keyboard
        """

        self.message = message
        self.invert_media = invert_media
        self.entities = entities
        self.reply_markup = reply_markup

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x86\xc7\x803' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.invert_media, 3)
                writer.string(self.message)

                if flags(self.entities, 1):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

                if flags(self.reply_markup, 2):
                    writer.object(
                        self.reply_markup,
                        group_id=0X146C1631
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        message_ = reader.string()
        entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(1) else None
        )

        reply_markup_ = (
            reader.object(
                group_id=0X146C1631
            )
            if flags(2) else None
        )

        return cls(
            message=message_,
            invert_media=flags(3),
            entities=entities_,
            reply_markup=reply_markup_
        )

class InputBotInlineMessageText(TLObject, family='TypeInputBotInlineMessage'):
    """
    Simple text message
    """

    _id = 0X3DCD7A87
    _group_id = 0X18FB8A33

    def __init__(
        self,
        message: str,
        no_webpage: bool = False,
        invert_media: bool = False,
        entities: Optional[List['TypeMessageEntity']] = None,
        reply_markup: Optional['TypeReplyMarkup'] = None
    ):

        """
        Simple text message

        Args:
            message (str): Message
            no_webpage (bool, optional): Disable webpage preview
            invert_media (bool, optional): If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
            entities (Optional[List['TypeMessageEntity']], optional): [Message entities for styled text](https://core.telegram.org/api/entities)
            reply_markup (Optional['TypeReplyMarkup'], optional): Inline keyboard
        """

        self.message = message
        self.no_webpage = no_webpage
        self.invert_media = invert_media
        self.entities = entities
        self.reply_markup = reply_markup

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x87z\xcd=' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.no_webpage, 0)
                flags(self.invert_media, 3)
                writer.string(self.message)

                if flags(self.entities, 1):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

                if flags(self.reply_markup, 2):
                    writer.object(
                        self.reply_markup,
                        group_id=0X146C1631
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        message_ = reader.string()
        entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(1) else None
        )

        reply_markup_ = (
            reader.object(
                group_id=0X146C1631
            )
            if flags(2) else None
        )

        return cls(
            message=message_,
            no_webpage=flags(0),
            invert_media=flags(3),
            entities=entities_,
            reply_markup=reply_markup_
        )

class InputBotInlineMessageMediaGeo(TLObject, family='TypeInputBotInlineMessage'):
    """
    Geolocation
    """

    _id = 0X96929A85
    _group_id = 0X18FB8A33

    def __init__(
        self,
        geo_point: 'TypeInputGeoPoint',
        heading: Optional[int] = None,
        period: Optional[int] = None,
        proximity_notification_radius: Optional[int] = None,
        reply_markup: Optional['TypeReplyMarkup'] = None
    ):

        """
        Geolocation

        Args:
            geo_point ('TypeInputGeoPoint'): Geolocation
            heading (Optional[int], optional): For [live locations](https://core.telegram.org/api/live-location), a direction in which the location moves, in degrees; 1-360
            period (Optional[int], optional): Validity period
            proximity_notification_radius (Optional[int], optional): For [live locations](https://core.telegram.org/api/live-location), a maximum distance to another chat member for proximity alerts, in meters (0-100000)
            reply_markup (Optional['TypeReplyMarkup'], optional): Reply markup for bot/inline keyboards
        """

        self.geo_point = geo_point
        self.heading = heading
        self.period = period
        self.proximity_notification_radius = proximity_notification_radius
        self.reply_markup = reply_markup

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x85\x9a\x92\x96' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.geo_point,
                    group_id=0XF78B3873
                )

                if flags(self.heading, 0):
                    writer.int(self.heading)

                if flags(self.period, 1):
                    writer.int(self.period)

                if flags(self.proximity_notification_radius, 3):
                    writer.int(self.proximity_notification_radius)

                if flags(self.reply_markup, 2):
                    writer.object(
                        self.reply_markup,
                        group_id=0X146C1631
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        geo_point_ = reader.object(
            group_id=0XF78B3873
        )

        heading_ = (
            reader.int()
            if flags(0) else None
        )

        period_ = (
            reader.int()
            if flags(1) else None
        )

        proximity_notification_radius_ = (
            reader.int()
            if flags(3) else None
        )

        reply_markup_ = (
            reader.object(
                group_id=0X146C1631
            )
            if flags(2) else None
        )

        return cls(
            geo_point=geo_point_,
            heading=heading_,
            period=period_,
            proximity_notification_radius=proximity_notification_radius_,
            reply_markup=reply_markup_
        )

class InputBotInlineMessageMediaVenue(TLObject, family='TypeInputBotInlineMessage'):
    """
    Venue
    """

    _id = 0X417BBF11
    _group_id = 0X18FB8A33

    def __init__(
        self,
        geo_point: 'TypeInputGeoPoint',
        title: str,
        address: str,
        provider: str,
        venue_id: str,
        venue_type: str,
        reply_markup: Optional['TypeReplyMarkup'] = None
    ):

        """
        Venue

        Args:
            geo_point ('TypeInputGeoPoint'): Geolocation
            title (str): Venue name
            address (str): Address
            provider (str): Venue provider: currently only "foursquare" and "gplaces" (Google Places) need to be supported
            venue_id (str): Venue ID in the provider's database
            venue_type (str): Venue type in the provider's database
            reply_markup (Optional['TypeReplyMarkup'], optional): Inline keyboard
        """

        self.geo_point = geo_point
        self.title = title
        self.address = address
        self.provider = provider
        self.venue_id = venue_id
        self.venue_type = venue_type
        self.reply_markup = reply_markup

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x11\xbf{A' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.geo_point,
                    group_id=0XF78B3873
                )
                writer.string(self.title)
                writer.string(self.address)
                writer.string(self.provider)
                writer.string(self.venue_id)
                writer.string(self.venue_type)

                if flags(self.reply_markup, 2):
                    writer.object(
                        self.reply_markup,
                        group_id=0X146C1631
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        geo_point_ = reader.object(
            group_id=0XF78B3873
        )

        title_ = reader.string()
        address_ = reader.string()
        provider_ = reader.string()
        venue_id_ = reader.string()
        venue_type_ = reader.string()
        reply_markup_ = (
            reader.object(
                group_id=0X146C1631
            )
            if flags(2) else None
        )

        return cls(
            geo_point=geo_point_,
            title=title_,
            address=address_,
            provider=provider_,
            venue_id=venue_id_,
            venue_type=venue_type_,
            reply_markup=reply_markup_
        )

class InputBotInlineMessageMediaContact(TLObject, family='TypeInputBotInlineMessage'):
    """
    A contact
    """

    _id = 0XA6EDBFFD
    _group_id = 0X18FB8A33

    def __init__(
        self,
        phone_number: str,
        first_name: str,
        last_name: str,
        vcard: str,
        reply_markup: Optional['TypeReplyMarkup'] = None
    ):

        """
        A contact

        Args:
            phone_number (str): Phone number
            first_name (str): First name
            last_name (str): Last name
            vcard (str): VCard info
            reply_markup (Optional['TypeReplyMarkup'], optional): Inline keyboard
        """

        self.phone_number = phone_number
        self.first_name = first_name
        self.last_name = last_name
        self.vcard = vcard
        self.reply_markup = reply_markup

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xfd\xbf\xed\xa6' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.phone_number)
                writer.string(self.first_name)
                writer.string(self.last_name)
                writer.string(self.vcard)

                if flags(self.reply_markup, 2):
                    writer.object(
                        self.reply_markup,
                        group_id=0X146C1631
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        phone_number_ = reader.string()
        first_name_ = reader.string()
        last_name_ = reader.string()
        vcard_ = reader.string()
        reply_markup_ = (
            reader.object(
                group_id=0X146C1631
            )
            if flags(2) else None
        )

        return cls(
            phone_number=phone_number_,
            first_name=first_name_,
            last_name=last_name_,
            vcard=vcard_,
            reply_markup=reply_markup_
        )

class InputBotInlineMessageGame(TLObject, family='TypeInputBotInlineMessage'):
    """
    A game
    """

    _id = 0X4B425864
    _group_id = 0X18FB8A33

    def __init__(
        self,
        reply_markup: Optional['TypeReplyMarkup'] = None
    ):

        """
        A game

        Args:
            reply_markup (Optional['TypeReplyMarkup'], optional): Inline keyboard
        """

        self.reply_markup = reply_markup

    def to_bytes(self, boxed: bool=True):
        with Writer(b'dXBK' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.reply_markup, 2):
                    writer.object(
                        self.reply_markup,
                        group_id=0X146C1631
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        reply_markup_ = (
            reader.object(
                group_id=0X146C1631
            )
            if flags(2) else None
        )

        return cls(
            reply_markup=reply_markup_
        )

class InputBotInlineMessageMediaInvoice(TLObject, family='TypeInputBotInlineMessage'):
    """
    An invoice
    """

    _id = 0XD7E78225
    _group_id = 0X18FB8A33

    def __init__(
        self,
        title: str,
        description: str,
        invoice: 'TypeInvoice',
        payload: bytes,
        provider: str,
        provider_data: 'TypeDataJSON',
        photo: Optional['TypeInputWebDocument'] = None,
        reply_markup: Optional['TypeReplyMarkup'] = None
    ):

        """
        An invoice

        Args:
            title (str): Product name, 1-32 characters
            description (str): Product description, 1-255 characters
            invoice ('TypeInvoice'): The invoice
            payload (bytes): Bot-defined invoice payload, 1-128 bytes. This will not be displayed to the user, use for your internal processes.
            provider (str): Payments provider token, obtained via [Botfather](https://t.me/botfather)
            provider_data ('TypeDataJSON'): A JSON-serialized object for data about the invoice, which will be shared with the payment provider. A detailed description of the required fields should be provided by the payment provider.
            photo (Optional['TypeInputWebDocument'], optional): Invoice photo
            reply_markup (Optional['TypeReplyMarkup'], optional): Inline keyboard
        """

        self.title = title
        self.description = description
        self.invoice = invoice
        self.payload = payload
        self.provider = provider
        self.provider_data = provider_data
        self.photo = photo
        self.reply_markup = reply_markup

    def to_bytes(self, boxed: bool=True):
        with Writer(b'%\x82\xe7\xd7' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.title)
                writer.string(self.description)

                if flags(self.photo, 0):
                    writer.object(
                        self.photo,
                        group_id=0X1AFB92D5
                    )
                writer.object(
                    self.invoice,
                    group_id=0X3A02DB4
                )
                writer.bytes(self.payload)
                writer.string(self.provider)
                writer.object(
                    self.provider_data,
                    group_id=0XE95B0798
                )

                if flags(self.reply_markup, 2):
                    writer.object(
                        self.reply_markup,
                        group_id=0X146C1631
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        title_ = reader.string()
        description_ = reader.string()
        photo_ = (
            reader.object(
                group_id=0X1AFB92D5
            )
            if flags(0) else None
        )

        invoice_ = reader.object(
            group_id=0X3A02DB4
        )

        payload_ = reader.bytes()
        provider_ = reader.string()
        provider_data_ = reader.object(
            group_id=0XE95B0798
        )

        reply_markup_ = (
            reader.object(
                group_id=0X146C1631
            )
            if flags(2) else None
        )

        return cls(
            title=title_,
            description=description_,
            invoice=invoice_,
            payload=payload_,
            provider=provider_,
            provider_data=provider_data_,
            photo=photo_,
            reply_markup=reply_markup_
        )

class InputBotInlineMessageMediaWebPage(TLObject, family='TypeInputBotInlineMessage'):
    """
    Specifies options that will be used to generate the link preview for the message, or even a standalone link preview without an attached message.
    """

    _id = 0XBDDCC510
    _group_id = 0X18FB8A33

    def __init__(
        self,
        message: str,
        url: str,
        invert_media: bool = False,
        force_large_media: bool = False,
        force_small_media: bool = False,
        optional: bool = False,
        entities: Optional[List['TypeMessageEntity']] = None,
        reply_markup: Optional['TypeReplyMarkup'] = None
    ):

        """
        Specifies options that will be used to generate the link preview for the message, or even a standalone link preview without an attached message.

        Args:
            message (str): The message, can be empty.
            url (str): The URL to use for the link preview.
            invert_media (bool, optional): If set, any eventual webpage preview will be shown on top of the message instead of at the bottom.
            force_large_media (bool, optional): If set, specifies that a large media preview should be used.
            force_small_media (bool, optional): If set, specifies that a small media preview should be used.
            optional (bool, optional): If not set, a WEBPAGE_NOT_FOUND RPC error will be emitted if a webpage preview cannot be generated for the specified url; otherwise, no error will be emitted (unless the provided message is also empty, in which case a MESSAGE_EMPTY will be emitted, instead).
            entities (Optional[List['TypeMessageEntity']], optional): [Message entities for styled text](https://core.telegram.org/api/entities)
            reply_markup (Optional['TypeReplyMarkup'], optional): Inline keyboard
        """

        self.message = message
        self.url = url
        self.invert_media = invert_media
        self.force_large_media = force_large_media
        self.force_small_media = force_small_media
        self.optional = optional
        self.entities = entities
        self.reply_markup = reply_markup

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x10\xc5\xdc\xbd' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.invert_media, 3)
                flags(self.force_large_media, 4)
                flags(self.force_small_media, 5)
                flags(self.optional, 6)
                writer.string(self.message)

                if flags(self.entities, 1):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )
                writer.string(self.url)

                if flags(self.reply_markup, 2):
                    writer.object(
                        self.reply_markup,
                        group_id=0X146C1631
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        message_ = reader.string()
        entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(1) else None
        )

        url_ = reader.string()
        reply_markup_ = (
            reader.object(
                group_id=0X146C1631
            )
            if flags(2) else None
        )

        return cls(
            message=message_,
            url=url_,
            invert_media=flags(3),
            force_large_media=flags(4),
            force_small_media=flags(5),
            optional=flags(6),
            entities=entities_,
            reply_markup=reply_markup_
        )

TypeInputBotInlineMessage = Union[
    InputBotInlineMessageMediaAuto,
    InputBotInlineMessageText,
    InputBotInlineMessageMediaGeo,
    InputBotInlineMessageMediaVenue,
    InputBotInlineMessageMediaContact,
    InputBotInlineMessageGame,
    InputBotInlineMessageMediaInvoice,
    InputBotInlineMessageMediaWebPage
]