
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class InputBotInlineMessageID(TLObject, family='TypeInputBotInlineMessageID'):
    """
    Represents a sent inline message from the perspective of a bot (legacy constructor)
    """

    _id = 0X890C3D89
    _group_id = 0XE8D574CF

    def __init__(
        self,
        dc_id: int,
        id: int,
        access_hash: int
    ):

        """
        Represents a sent inline message from the perspective of a bot (legacy constructor)

        Args:
            dc_id (int): DC ID to use when working with this inline message
            id (int): ID of message, contains both the (32-bit, legacy) owner ID and the message ID, used only for Bot API backwards compatibility with 32-bit user ID.
            access_hash (int): Access hash of message
        """

        self.dc_id = dc_id
        self.id = id
        self.access_hash = access_hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x89=\x0c\x89' if boxed else b'') as writer:
            writer.int(self.dc_id)
            writer.long(self.id)
            writer.long(self.access_hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        dc_id_ = reader.int()
        id_ = reader.long()
        access_hash_ = reader.long()

        return cls(
            dc_id=dc_id_,
            id=id_,
            access_hash=access_hash_
        )

class InputBotInlineMessageID64(TLObject, family='TypeInputBotInlineMessageID'):
    """
    Represents a sent inline message from the perspective of a bot
    """

    _id = 0XB6D915D7
    _group_id = 0XE8D574CF

    def __init__(
        self,
        dc_id: int,
        owner_id: int,
        id: int,
        access_hash: int
    ):

        """
        Represents a sent inline message from the perspective of a bot

        Args:
            dc_id (int): DC ID to use when working with this inline message
            owner_id (int): ID of the owner of this message
            id (int): ID of message
            access_hash (int): Access hash of message
        """

        self.dc_id = dc_id
        self.owner_id = owner_id
        self.id = id
        self.access_hash = access_hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd7\x15\xd9\xb6' if boxed else b'') as writer:
            writer.int(self.dc_id)
            writer.long(self.owner_id)
            writer.int(self.id)
            writer.long(self.access_hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        dc_id_ = reader.int()
        owner_id_ = reader.long()
        id_ = reader.int()
        access_hash_ = reader.long()

        return cls(
            dc_id=dc_id_,
            owner_id=owner_id_,
            id=id_,
            access_hash=access_hash_
        )

TypeInputBotInlineMessageID = Union[
    InputBotInlineMessageID,
    InputBotInlineMessageID64
]