
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .input_peer import TypeInputPeer
    from ...gadgets.byteutils import Reader


class InputNotifyPeer(TLObject, family='TypeInputNotifyPeer'):
    """
    Notifications generated by a certain user or group.
    """

    _id = 0XB8BC5B0C
    _group_id = 0XF4A6141A

    def __init__(
        self,
        peer: 'TypeInputPeer'
    ):

        """
        Notifications generated by a certain user or group.

        Args:
            peer ('TypeInputPeer'): User or group
        """

        self.peer = peer

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x0c[\xbc\xb8' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0X995DB9DF
        )

        return cls(
            peer=peer_
        )

class InputNotifyUsers(TLObject, family='TypeInputNotifyPeer'):
    """
    Notifications generated by all users.
    """

    _id = 0X193B4417
    _group_id = 0XF4A6141A


    def to_bytes(self, boxed: bool=True):
        return b'\x17D;\x19' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputNotifyChats(TLObject, family='TypeInputNotifyPeer'):
    """
    Notifications generated by all groups.
    """

    _id = 0X4A95E84E
    _group_id = 0XF4A6141A


    def to_bytes(self, boxed: bool=True):
        return b'N\xe8\x95J' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputNotifyBroadcasts(TLObject, family='TypeInputNotifyPeer'):
    """
    All [channels](https://core.telegram.org/api/channel)
    """

    _id = 0XB1DB7C7E
    _group_id = 0XF4A6141A


    def to_bytes(self, boxed: bool=True):
        return b'~|\xdb\xb1' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class InputNotifyForumTopic(TLObject, family='TypeInputNotifyPeer'):
    """
    Notifications generated by a [topic](https://core.telegram.org/api/forum#forum-topics) in a [forum](https://core.telegram.org/api/forum).
    """

    _id = 0X5C467992
    _group_id = 0XF4A6141A

    def __init__(
        self,
        peer: 'TypeInputPeer',
        top_msg_id: int
    ):

        """
        Notifications generated by a [topic](https://core.telegram.org/api/forum#forum-topics) in a [forum](https://core.telegram.org/api/forum).

        Args:
            peer ('TypeInputPeer'): Forum ID
            top_msg_id (int): [Topic ID](https://core.telegram.org/api/forum#forum-topics)
        """

        self.peer = peer
        self.top_msg_id = top_msg_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x92yF\\' if boxed else b'') as writer:
            writer.object(
                self.peer,
                group_id=0X995DB9DF
            )
            writer.int(self.top_msg_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        peer_ = reader.object(
            group_id=0X995DB9DF
        )

        top_msg_id_ = reader.int()

        return cls(
            peer=peer_,
            top_msg_id=top_msg_id_
        )

TypeInputNotifyPeer = Union[
    InputNotifyPeer,
    InputNotifyUsers,
    InputNotifyChats,
    InputNotifyBroadcasts,
    InputNotifyForumTopic
]