
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class InputSecureFileUploaded(TLObject, family='TypeInputSecureFile'):
    """
    Uploaded secure file, for more info [see the passport docs](https://core.telegram.org/passport/encryption#inputsecurefile)
    """

    _id = 0X3334B0F0
    _group_id = 0X76F6AFF3

    def __init__(
        self,
        id: int,
        parts: int,
        md5_checksum: str,
        file_hash: bytes,
        secret: bytes
    ):

        """
        Uploaded secure file, for more info [see the passport docs](https://core.telegram.org/passport/encryption#inputsecurefile)

        Args:
            id (int): Secure file ID
            parts (int): Secure file part count
            md5_checksum (str): MD5 hash of encrypted uploaded file, to be checked server-side
            file_hash (bytes): File hash
            secret (bytes): Secret
        """

        self.id = id
        self.parts = parts
        self.md5_checksum = md5_checksum
        self.file_hash = file_hash
        self.secret = secret

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xf0\xb043' if boxed else b'') as writer:
            writer.long(self.id)
            writer.int(self.parts)
            writer.string(self.md5_checksum)
            writer.bytes(self.file_hash)
            writer.bytes(self.secret)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        parts_ = reader.int()
        md5_checksum_ = reader.string()
        file_hash_ = reader.bytes()
        secret_ = reader.bytes()

        return cls(
            id=id_,
            parts=parts_,
            md5_checksum=md5_checksum_,
            file_hash=file_hash_,
            secret=secret_
        )

class InputSecureFile(TLObject, family='TypeInputSecureFile'):
    """
    Pre-uploaded [passport](https://core.telegram.org/passport) file, for more info [see the passport docs](https://core.telegram.org/passport/encryption#inputsecurefile)
    """

    _id = 0X5367E5BE
    _group_id = 0X76F6AFF3

    def __init__(
        self,
        id: int,
        access_hash: int
    ):

        """
        Pre-uploaded [passport](https://core.telegram.org/passport) file, for more info [see the passport docs](https://core.telegram.org/passport/encryption#inputsecurefile)

        Args:
            id (int): Secure file ID
            access_hash (int): Secure file access hash
        """

        self.id = id
        self.access_hash = access_hash

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xbe\xe5gS' if boxed else b'') as writer:
            writer.long(self.id)
            writer.long(self.access_hash)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        id_ = reader.long()
        access_hash_ = reader.long()

        return cls(
            id=id_,
            access_hash=access_hash_
        )

TypeInputSecureFile = Union[
    InputSecureFileUploaded,
    InputSecureFile
]