
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .reaction import TypeReaction
    from .geo_point import TypeGeoPoint
    from .input_channel import TypeInputChannel
    from .geo_point_address import TypeGeoPointAddress
    from ...gadgets.byteutils import Reader
    from .media_area_coordinates import TypeMediaAreaCoordinates


class MediaAreaVenue(TLObject, family='TypeMediaArea'):
    """
    Represents a location tag attached to a [story](https://core.telegram.org/api/stories), with additional venue information.
    """

    _id = 0XBE82DB9C
    _group_id = 0XA32C529B

    def __init__(
        self,
        coordinates: 'TypeMediaAreaCoordinates',
        geo: 'TypeGeoPoint',
        title: str,
        address: str,
        provider: str,
        venue_id: str,
        venue_type: str
    ):

        """
        Represents a location tag attached to a [story](https://core.telegram.org/api/stories), with additional venue information.

        Args:
            coordinates ('TypeMediaAreaCoordinates'): The size and location of the media area corresponding to the location sticker on top of the story media.
            geo ('TypeGeoPoint'): Coordinates of the venue
            title (str): Venue name
            address (str): Address
            provider (str): Venue provider: currently only "foursquare" needs to be supported.
            venue_id (str): Venue ID in the provider's database
            venue_type (str): Venue type in the provider's database
        """

        self.coordinates = coordinates
        self.geo = geo
        self.title = title
        self.address = address
        self.provider = provider
        self.venue_id = venue_id
        self.venue_type = venue_type

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9c\xdb\x82\xbe' if boxed else b'') as writer:
            writer.object(
                self.coordinates,
                group_id=0X195AE81C
            )
            writer.object(
                self.geo,
                group_id=0X9248B41D
            )
            writer.string(self.title)
            writer.string(self.address)
            writer.string(self.provider)
            writer.string(self.venue_id)
            writer.string(self.venue_type)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        coordinates_ = reader.object(
            group_id=0X195AE81C
        )

        geo_ = reader.object(
            group_id=0X9248B41D
        )

        title_ = reader.string()
        address_ = reader.string()
        provider_ = reader.string()
        venue_id_ = reader.string()
        venue_type_ = reader.string()

        return cls(
            coordinates=coordinates_,
            geo=geo_,
            title=title_,
            address=address_,
            provider=provider_,
            venue_id=venue_id_,
            venue_type=venue_type_
        )

class InputMediaAreaVenue(TLObject, family='TypeMediaArea'):
    """
    Represents a [location tag](https://core.telegram.org/api/stories#media-areas) attached to a [story](https://core.telegram.org/api/stories), with additional venue information.
    """

    _id = 0XB282217F
    _group_id = 0XA32C529B

    def __init__(
        self,
        coordinates: 'TypeMediaAreaCoordinates',
        query_id: int,
        result_id: str
    ):

        """
        Represents a [location tag](https://core.telegram.org/api/stories#media-areas) attached to a [story](https://core.telegram.org/api/stories), with additional venue information.

        Args:
            coordinates ('TypeMediaAreaCoordinates'): The size and location of the media area corresponding to the location sticker on top of the story media.
            query_id (int): The query_id from [messages.botResults](https://core.telegram.org/constructor/messages.botResults), see [here](https://core.telegram.org/api/stories#media-areas) for more info.
            result_id (str): The id of the chosen result, see [here](https://core.telegram.org/api/stories#media-areas) for more info.
        """

        self.coordinates = coordinates
        self.query_id = query_id
        self.result_id = result_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x7f!\x82\xb2' if boxed else b'') as writer:
            writer.object(
                self.coordinates,
                group_id=0X195AE81C
            )
            writer.long(self.query_id)
            writer.string(self.result_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        coordinates_ = reader.object(
            group_id=0X195AE81C
        )

        query_id_ = reader.long()
        result_id_ = reader.string()

        return cls(
            coordinates=coordinates_,
            query_id=query_id_,
            result_id=result_id_
        )

class MediaAreaGeoPoint(TLObject, family='TypeMediaArea'):
    """
    Represents a geolocation tag attached to a [story](https://core.telegram.org/api/stories).
    """

    _id = 0XCAD5452D
    _group_id = 0XA32C529B

    def __init__(
        self,
        coordinates: 'TypeMediaAreaCoordinates',
        geo: 'TypeGeoPoint',
        address: Optional['TypeGeoPointAddress'] = None
    ):

        """
        Represents a geolocation tag attached to a [story](https://core.telegram.org/api/stories).

        Args:
            coordinates ('TypeMediaAreaCoordinates'): The size and position of the media area corresponding to the location sticker on top of the story media.
            geo ('TypeGeoPoint'): Coordinates of the geolocation tag.
            address (Optional['TypeGeoPointAddress'], optional): Optional textual representation of the address.
        """

        self.coordinates = coordinates
        self.geo = geo
        self.address = address

    def to_bytes(self, boxed: bool=True):
        with Writer(b'-E\xd5\xca' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.coordinates,
                    group_id=0X195AE81C
                )
                writer.object(
                    self.geo,
                    group_id=0X9248B41D
                )

                if flags(self.address, 0):
                    writer.object(
                        self.address,
                        group_id=0X3A6BC0D7
                    )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        coordinates_ = reader.object(
            group_id=0X195AE81C
        )

        geo_ = reader.object(
            group_id=0X9248B41D
        )

        address_ = (
            reader.object(
                group_id=0X3A6BC0D7
            )
            if flags(0) else None
        )

        return cls(
            coordinates=coordinates_,
            geo=geo_,
            address=address_
        )

class MediaAreaSuggestedReaction(TLObject, family='TypeMediaArea'):
    """
    Represents a reaction bubble.
    """

    _id = 0X14455871
    _group_id = 0XA32C529B

    def __init__(
        self,
        coordinates: 'TypeMediaAreaCoordinates',
        reaction: 'TypeReaction',
        dark: bool = False,
        flipped: bool = False
    ):

        """
        Represents a reaction bubble.

        Args:
            coordinates ('TypeMediaAreaCoordinates'): The coordinates of the media area corresponding to the reaction button.
            reaction ('TypeReaction'): The reaction that should be sent when this area is clicked.
            dark (bool, optional): Whether the reaction bubble has a dark background.
            flipped (bool, optional): Whether the reaction bubble is mirrored (see [here](https://core.telegram.org/api/stories#reactions) for more info).
        """

        self.coordinates = coordinates
        self.reaction = reaction
        self.dark = dark
        self.flipped = flipped

    def to_bytes(self, boxed: bool=True):
        with Writer(b'qXE\x14' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.dark, 0)
                flags(self.flipped, 1)
                writer.object(
                    self.coordinates,
                    group_id=0X195AE81C
                )
                writer.object(
                    self.reaction,
                    group_id=0X19F930D1
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        coordinates_ = reader.object(
            group_id=0X195AE81C
        )

        reaction_ = reader.object(
            group_id=0X19F930D1
        )

        return cls(
            coordinates=coordinates_,
            reaction=reaction_,
            dark=flags(0),
            flipped=flags(1)
        )

class MediaAreaChannelPost(TLObject, family='TypeMediaArea'):
    """
    Represents a channel post.
    """

    _id = 0X770416AF
    _group_id = 0XA32C529B

    def __init__(
        self,
        coordinates: 'TypeMediaAreaCoordinates',
        channel_id: int,
        msg_id: int
    ):

        """
        Represents a channel post.

        Args:
            coordinates ('TypeMediaAreaCoordinates'): The size and location of the media area corresponding to the location sticker on top of the story media.
            channel_id (int): The channel that posted the message
            msg_id (int): ID of the channel message
        """

        self.coordinates = coordinates
        self.channel_id = channel_id
        self.msg_id = msg_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xaf\x16\x04w' if boxed else b'') as writer:
            writer.object(
                self.coordinates,
                group_id=0X195AE81C
            )
            writer.long(self.channel_id)
            writer.int(self.msg_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        coordinates_ = reader.object(
            group_id=0X195AE81C
        )

        channel_id_ = reader.long()
        msg_id_ = reader.int()

        return cls(
            coordinates=coordinates_,
            channel_id=channel_id_,
            msg_id=msg_id_
        )

class InputMediaAreaChannelPost(TLObject, family='TypeMediaArea'):
    """
    Represents a channel post
    """

    _id = 0X2271F2BF
    _group_id = 0XA32C529B

    def __init__(
        self,
        coordinates: 'TypeMediaAreaCoordinates',
        channel: 'TypeInputChannel',
        msg_id: int
    ):

        """
        Represents a channel post

        Args:
            coordinates ('TypeMediaAreaCoordinates'): The size and location of the media area corresponding to the location sticker on top of the story media.
            channel ('TypeInputChannel'): The channel that posted the message
            msg_id (int): ID of the channel message
        """

        self.coordinates = coordinates
        self.channel = channel
        self.msg_id = msg_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xbf\xf2q"' if boxed else b'') as writer:
            writer.object(
                self.coordinates,
                group_id=0X195AE81C
            )
            writer.object(
                self.channel,
                group_id=0X42691CEF
            )
            writer.int(self.msg_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        coordinates_ = reader.object(
            group_id=0X195AE81C
        )

        channel_ = reader.object(
            group_id=0X42691CEF
        )

        msg_id_ = reader.int()

        return cls(
            coordinates=coordinates_,
            channel=channel_,
            msg_id=msg_id_
        )

class MediaAreaUrl(TLObject, family='TypeMediaArea'):
    """
    Represents a [URL media area](https://core.telegram.org/api/stories#urls).
    """

    _id = 0X37381085
    _group_id = 0XA32C529B

    def __init__(
        self,
        coordinates: 'TypeMediaAreaCoordinates',
        url: str
    ):

        """
        Represents a [URL media area](https://core.telegram.org/api/stories#urls).

        Args:
            coordinates ('TypeMediaAreaCoordinates'): The size and location of the media area corresponding to the URL button on top of the story media.
            url (str): URL to open when clicked.
        """

        self.coordinates = coordinates
        self.url = url

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x85\x1087' if boxed else b'') as writer:
            writer.object(
                self.coordinates,
                group_id=0X195AE81C
            )
            writer.string(self.url)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        coordinates_ = reader.object(
            group_id=0X195AE81C
        )

        url_ = reader.string()

        return cls(
            coordinates=coordinates_,
            url=url_
        )

class MediaAreaWeather(TLObject, family='TypeMediaArea'):
    """
    Represents a [weather widget](https://core.telegram.org/api/stories#weather).
    """

    _id = 0X49A6549C
    _group_id = 0XA32C529B

    def __init__(
        self,
        coordinates: 'TypeMediaAreaCoordinates',
        emoji: str,
        temperature_c: float,
        color: int
    ):

        """
        Represents a [weather widget](https://core.telegram.org/api/stories#weather).

        Args:
            coordinates ('TypeMediaAreaCoordinates'): The size and location of the media area corresponding to the widget on top of the story media.
            emoji (str): Weather emoji, should be rendered as an [animated emoji](https://core.telegram.org/api/animated-emojis).
            temperature_c (float): Temperature in degrees Celsius.
            color (int): ARGB background color.
        """

        self.coordinates = coordinates
        self.emoji = emoji
        self.temperature_c = temperature_c
        self.color = color

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x9cT\xa6I' if boxed else b'') as writer:
            writer.object(
                self.coordinates,
                group_id=0X195AE81C
            )
            writer.string(self.emoji)
            writer.double(self.temperature_c)
            writer.int(self.color)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        coordinates_ = reader.object(
            group_id=0X195AE81C
        )

        emoji_ = reader.string()
        temperature_c_ = reader.double()
        color_ = reader.int()

        return cls(
            coordinates=coordinates_,
            emoji=emoji_,
            temperature_c=temperature_c_,
            color=color_
        )

class MediaAreaStarGift(TLObject, family='TypeMediaArea'):
    _id = 0X5787686D
    _group_id = 0XA32C529B

    def __init__(
        self,
        coordinates: 'TypeMediaAreaCoordinates',
        slug: str
    ):

        self.coordinates = coordinates
        self.slug = slug

    def to_bytes(self, boxed: bool=True):
        with Writer(b'mh\x87W' if boxed else b'') as writer:
            writer.object(
                self.coordinates,
                group_id=0X195AE81C
            )
            writer.string(self.slug)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        coordinates_ = reader.object(
            group_id=0X195AE81C
        )

        slug_ = reader.string()

        return cls(
            coordinates=coordinates_,
            slug=slug_
        )

TypeMediaArea = Union[
    MediaAreaVenue,
    InputMediaAreaVenue,
    MediaAreaGeoPoint,
    MediaAreaSuggestedReaction,
    MediaAreaChannelPost,
    InputMediaAreaChannelPost,
    MediaAreaUrl,
    MediaAreaWeather,
    MediaAreaStarGift
]