
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from .reaction import TypeReaction
    from ...gadgets.byteutils import Reader


class MessagePeerReaction(TLObject, family='TypeMessagePeerReaction'):
    """
    How a certain peer reacted to the message
    """

    _id = 0X8C79B63C
    _group_id = 0X6A319223

    def __init__(
        self,
        peer_id: 'TypePeer',
        date: int,
        reaction: 'TypeReaction',
        big: bool = False,
        unread: bool = False,
        my: bool = False
    ):

        """
        How a certain peer reacted to the message

        Args:
            peer_id ('TypePeer'): Peer that reacted to the message
            date (int): When was this reaction added
            reaction ('TypeReaction'): Reaction emoji
            big (bool, optional): Whether the specified [message reaction](https://core.telegram.org/api/reactions) should elicit a bigger and longer reaction
            unread (bool, optional): Whether the reaction wasn't yet marked as read by the current user
            my (bool, optional): Starting from layer 159, [messages.sendReaction](https://core.telegram.org/method/messages.sendReaction) will send reactions from the peer (user or channel) specified using [messages.saveDefaultSendAs](https://core.telegram.org/method/messages.saveDefaultSendAs). If set, this flag indicates that this reaction was sent by us, even if the peer doesn't point to the current account.
        """

        self.peer_id = peer_id
        self.date = date
        self.reaction = reaction
        self.big = big
        self.unread = unread
        self.my = my

    def to_bytes(self, boxed: bool=True):
        with Writer(b'<\xb6y\x8c' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.big, 0)
                flags(self.unread, 1)
                flags(self.my, 2)
                writer.object(
                    self.peer_id,
                    group_id=0XB4DECBCA
                )
                writer.int(self.date)
                writer.object(
                    self.reaction,
                    group_id=0X19F930D1
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_id_ = reader.object(
            group_id=0XB4DECBCA
        )

        date_ = reader.int()
        reaction_ = reader.object(
            group_id=0X19F930D1
        )

        return cls(
            peer_id=peer_id_,
            date=date_,
            reaction=reaction_,
            big=flags(0),
            unread=flags(1),
            my=flags(2)
        )

TypeMessagePeerReaction = MessagePeerReaction