
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from ...gadgets.byteutils import Reader


class MessageReplies(TLObject, family='TypeMessageReplies'):
    """
    Info about [the comment section of a channel post, or a simple message thread](https://core.telegram.org/api/threads)
    """

    _id = 0X83D60FC2
    _group_id = 0XEE3613C9

    def __init__(
        self,
        replies: int,
        replies_pts: int,
        comments: bool = False,
        recent_repliers: Optional[List['TypePeer']] = None,
        channel_id: Optional[int] = None,
        max_id: Optional[int] = None,
        read_max_id: Optional[int] = None
    ):

        """
        Info about [the comment section of a channel post, or a simple message thread](https://core.telegram.org/api/threads)

        Args:
            replies (int): Contains the total number of replies in this thread or comment section.
            replies_pts (int): [PTS](https://core.telegram.org/api/updates) of the message that started this thread.
            comments (bool, optional): Whether this constructor contains information about the [comment section of a channel post, or a simple message thread](https://core.telegram.org/api/threads)
            recent_repliers (Optional[List['TypePeer']], optional): For channel post comments, contains information about the last few comment posters for a specific thread, to show a small list of commenter profile pictures in client previews.
            channel_id (Optional[int], optional): For channel post comments, contains the ID of the associated [discussion supergroup](https://core.telegram.org/api/discussion)
            max_id (Optional[int], optional): ID of the latest message in this thread or comment section.
            read_max_id (Optional[int], optional): Contains the ID of the latest read message in this thread or comment section.
        """

        self.replies = replies
        self.replies_pts = replies_pts
        self.comments = comments
        self.recent_repliers = recent_repliers
        self.channel_id = channel_id
        self.max_id = max_id
        self.read_max_id = read_max_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc2\x0f\xd6\x83' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.comments, 0)
                writer.int(self.replies)
                writer.int(self.replies_pts)

                if flags(self.recent_repliers, 1):
                    writer.vector(
                        self.recent_repliers,
                        lambda value: writer.object(
                            value,
                            group_id=0XB4DECBCA
                        )
                    )

                if flags(self.channel_id, 0):
                    writer.long(self.channel_id)

                if flags(self.max_id, 2):
                    writer.int(self.max_id)

                if flags(self.read_max_id, 3):
                    writer.int(self.read_max_id)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        replies_ = reader.int()
        replies_pts_ = reader.int()
        recent_repliers_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0XB4DECBCA
                )
            )
            if flags(1) else None
        )

        channel_id_ = (
            reader.long()
            if flags(0) else None
        )

        max_id_ = (
            reader.int()
            if flags(2) else None
        )

        read_max_id_ = (
            reader.int()
            if flags(3) else None
        )

        return cls(
            replies=replies_,
            replies_pts=replies_pts_,
            comments=flags(0),
            recent_repliers=recent_repliers_,
            channel_id=channel_id_,
            max_id=max_id_,
            read_max_id=read_max_id_
        )

TypeMessageReplies = MessageReplies