
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Union, Optional
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..sponsored_message import TypeSponsoredMessage
    from ....gadgets.byteutils import Reader


class SponsoredMessages(TLObject, family='TypeMessagesSponsoredMessages'):
    """
    A set of sponsored messages associated to a channel
    """

    _id = 0XFFDA656D
    _group_id = 0X24404B63

    def __init__(
        self,
        messages: List['TypeSponsoredMessage'],
        chats: List['TypeChat'],
        users: List['TypeUser'],
        posts_between: Optional[int] = None,
        start_delay: Optional[int] = None,
        between_delay: Optional[int] = None
    ):

        """
        A set of sponsored messages associated to a channel

        Args:
            messages (List['TypeSponsoredMessage']): Sponsored messages
            chats (List['TypeChat']): Chats mentioned in the sponsored messages
            users (List['TypeUser']): Users mentioned in the sponsored messages
            posts_between (Optional[int], optional): If set, specifies the minimum number of messages between shown sponsored messages; otherwise, only one sponsored message must be shown after all ordinary messages.
            start_delay (Optional[int], optional): ...
            between_delay (Optional[int], optional): ...
        """

        self.messages = messages
        self.chats = chats
        self.users = users
        self.posts_between = posts_between
        self.start_delay = start_delay
        self.between_delay = between_delay

    def to_bytes(self, boxed: bool=True):
        with Writer(b'me\xda\xff' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.posts_between, 0):
                    writer.int(self.posts_between)

                if flags(self.start_delay, 1):
                    writer.int(self.start_delay)

                if flags(self.between_delay, 2):
                    writer.int(self.between_delay)
                writer.vector(
                    self.messages,
                    lambda value: writer.object(
                        value,
                        group_id=0X7144FBA5
                    )
                )
                writer.vector(
                    self.chats,
                    lambda value: writer.object(
                        value,
                        group_id=0X73A5C0D9
                    )
                )
                writer.vector(
                    self.users,
                    lambda value: writer.object(
                        value,
                        group_id=0X9BABE43A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        posts_between_ = (
            reader.int()
            if flags(0) else None
        )

        start_delay_ = (
            reader.int()
            if flags(1) else None
        )

        between_delay_ = (
            reader.int()
            if flags(2) else None
        )

        messages_ = reader.vector(
            lambda: reader.object(
                group_id=0X7144FBA5
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            messages=messages_,
            chats=chats_,
            users=users_,
            posts_between=posts_between_,
            start_delay=start_delay_,
            between_delay=between_delay_
        )

class SponsoredMessagesEmpty(TLObject, family='TypeMessagesSponsoredMessages'):
    """
    No sponsored messages are available.
    """

    _id = 0X1839490F
    _group_id = 0X24404B63


    def to_bytes(self, boxed: bool=True):
        return b'\x0fI9\x18' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

TypeMessagesSponsoredMessages = Union[
    SponsoredMessages,
    SponsoredMessagesEmpty
]