
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ....gadgets.byteutils import Reader


class TranscribedAudio(TLObject, family='TypeMessagesTranscribedAudio'):
    """
    [Transcribed text from a voice message](https://core.telegram.org/api/transcribe)
    """

    _id = 0XCFB9D957
    _group_id = 0XFE3ED789

    def __init__(
        self,
        transcription_id: int,
        text: str,
        pending: bool = False,
        trial_remains_num: Optional[int] = None,
        trial_remains_until_date: Optional[int] = None
    ):

        """
        [Transcribed text from a voice message](https://core.telegram.org/api/transcribe)

        Args:
            transcription_id (int): Transcription ID
            text (str): Transcripted text
            pending (bool, optional): Whether the transcription is partial because audio transcription is still in progress, if set the user may receive further [updateTranscribedAudio](https://core.telegram.org/constructor/updateTranscribedAudio) updates with the updated transcription.
            trial_remains_num (Optional[int], optional): For non- [Premium](https://core.telegram.org/api/premium) users, this flag will be set, indicating the remaining transcriptions in the free trial period.
            trial_remains_until_date (Optional[int], optional): For non- [Premium](https://core.telegram.org/api/premium) users, this flag will be set, indicating the date when the trial_remains_num counter will be reset to the maximum value of [transcribe_audio_trial_weekly_number](https://core.telegram.org/api/config#transcribe-audio-trial-weekly-number).
        """

        self.transcription_id = transcription_id
        self.text = text
        self.pending = pending
        self.trial_remains_num = trial_remains_num
        self.trial_remains_until_date = trial_remains_until_date

    def to_bytes(self, boxed: bool=True):
        with Writer(b'W\xd9\xb9\xcf' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.pending, 0)
                writer.long(self.transcription_id)
                writer.string(self.text)

                if flags(self.trial_remains_num, 1):
                    writer.int(self.trial_remains_num)

                if flags(self.trial_remains_until_date, 1):
                    writer.int(self.trial_remains_until_date)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        transcription_id_ = reader.long()
        text_ = reader.string()
        trial_remains_num_ = (
            reader.int()
            if flags(1) else None
        )

        trial_remains_until_date_ = (
            reader.int()
            if flags(1) else None
        )

        return cls(
            transcription_id=transcription_id_,
            text=text_,
            pending=flags(0),
            trial_remains_num=trial_remains_num_,
            trial_remains_until_date=trial_remains_until_date_
        )

TypeMessagesTranscribedAudio = TranscribedAudio