
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, List
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..star_gift import TypeStarGift
    from ....gadgets.byteutils import Reader


class StarGiftsNotModified(TLObject, family='TypePaymentsStarGifts'):
    """
    The list of available [gifts](https://core.telegram.org/api/gifts) hasn't changed.
    """

    _id = 0XA388A368
    _group_id = 0XDD62258B


    def to_bytes(self, boxed: bool=True):
        return b'h\xa3\x88\xa3' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class StarGifts(TLObject, family='TypePaymentsStarGifts'):
    """
    Available [gifts](https://core.telegram.org/api/gifts).
    """

    _id = 0X2ED82995
    _group_id = 0XDD62258B

    def __init__(
        self,
        hash: int,
        gifts: List['TypeStarGift'],
        chats: List['TypeChat'],
        users: List['TypeUser']
    ):

        """
        Available [gifts](https://core.telegram.org/api/gifts).

        Args:
            hash (int): [Hash used for caching, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
            gifts (List['TypeStarGift']): List of available gifts.
            chats (List['TypeChat']): ...
            users (List['TypeUser']): ...
        """

        self.hash = hash
        self.gifts = gifts
        self.chats = chats
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x95)\xd8.' if boxed else b'') as writer:
            writer.int(self.hash)
            writer.vector(
                self.gifts,
                lambda value: writer.object(
                    value,
                    group_id=0X87440C7B
                )
            )
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        hash_ = reader.int()
        gifts_ = reader.vector(
            lambda: reader.object(
                group_id=0X87440C7B
            )
        )

        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            hash=hash_,
            gifts=gifts_,
            chats=chats_,
            users=users_
        )

TypePaymentsStarGifts = Union[
    StarGiftsNotModified,
    StarGifts
]