
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .peer import TypePeer
    from .story_item import TypeStoryItem
    from ...gadgets.byteutils import Reader


class PeerStories(TLObject, family='TypePeerStories'):
    """
    [Stories](https://core.telegram.org/api/stories) associated to a peer
    """

    _id = 0X9A35E999
    _group_id = 0XE4A19284

    def __init__(
        self,
        peer: 'TypePeer',
        stories: List['TypeStoryItem'],
        max_read_id: Optional[int] = None
    ):

        """
        [Stories](https://core.telegram.org/api/stories) associated to a peer

        Args:
            peer ('TypePeer'): The peer
            stories (List['TypeStoryItem']): Stories
            max_read_id (Optional[int], optional): If set, contains the ID of the maximum read story
        """

        self.peer = peer
        self.stories = stories
        self.max_read_id = max_read_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x99\xe95\x9a' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.object(
                    self.peer,
                    group_id=0XB4DECBCA
                )

                if flags(self.max_read_id, 0):
                    writer.int(self.max_read_id)
                writer.vector(
                    self.stories,
                    lambda value: writer.object(
                        value,
                        group_id=0X8436985A
                    )
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        peer_ = reader.object(
            group_id=0XB4DECBCA
        )

        max_read_id_ = (
            reader.int()
            if flags(0) else None
        )

        stories_ = reader.vector(
            lambda: reader.object(
                group_id=0X8436985A
            )
        )

        return cls(
            peer=peer_,
            stories=stories_,
            max_read_id=max_read_id_
        )

TypePeerStories = PeerStories