
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..chat import TypeChat
    from ..user import TypeUser
    from ..group_call import TypeGroupCall
    from ....gadgets.byteutils import Reader
    from ..group_call_participant import TypeGroupCallParticipant


class GroupCall(TLObject, family='TypePhoneGroupCall'):
    """
    Contains info about a group call, and partial info about its participants.
    """

    _id = 0X9E727AAD
    _group_id = 0X89AC92BF

    def __init__(
        self,
        call: 'TypeGroupCall',
        participants: List['TypeGroupCallParticipant'],
        participants_next_offset: str,
        chats: List['TypeChat'],
        users: List['TypeUser']
    ):

        """
        Contains info about a group call, and partial info about its participants.

        Args:
            call ('TypeGroupCall'): Info about the group call
            participants (List['TypeGroupCallParticipant']): A partial list of participants.
            participants_next_offset (str): Next offset to use when fetching the remaining participants using [phone.getGroupParticipants](https://core.telegram.org/method/phone.getGroupParticipants)
            chats (List['TypeChat']): Chats mentioned in the participants vector
            users (List['TypeUser']): Users mentioned in the participants vector
        """

        self.call = call
        self.participants = participants
        self.participants_next_offset = participants_next_offset
        self.chats = chats
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xadzr\x9e' if boxed else b'') as writer:
            writer.object(
                self.call,
                group_id=0X70F5DA49
            )
            writer.vector(
                self.participants,
                lambda value: writer.object(
                    value,
                    group_id=0XC404CB69
                )
            )
            writer.string(self.participants_next_offset)
            writer.vector(
                self.chats,
                lambda value: writer.object(
                    value,
                    group_id=0X73A5C0D9
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        call_ = reader.object(
            group_id=0X70F5DA49
        )

        participants_ = reader.vector(
            lambda: reader.object(
                group_id=0XC404CB69
            )
        )

        participants_next_offset_ = reader.string()
        chats_ = reader.vector(
            lambda: reader.object(
                group_id=0X73A5C0D9
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            call=call_,
            participants=participants_,
            participants_next_offset=participants_next_offset_,
            chats=chats_,
            users=users_
        )

TypePhoneGroupCall = GroupCall