
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Union
from ....gadgets.tlobject import TLObject
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ..user import TypeUser
    from ..photo import TypePhoto
    from ....gadgets.byteutils import Reader


class Photos(TLObject, family='TypePhotosPhotos'):
    """
    Full list of photos with auxiliary data.
    """

    _id = 0X8DCA6AA5
    _group_id = 0X48D204C5

    def __init__(
        self,
        photos: List['TypePhoto'],
        users: List['TypeUser']
    ):

        """
        Full list of photos with auxiliary data.

        Args:
            photos (List['TypePhoto']): List of photos
            users (List['TypeUser']): List of mentioned users
        """

        self.photos = photos
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xa5j\xca\x8d' if boxed else b'') as writer:
            writer.vector(
                self.photos,
                lambda value: writer.object(
                    value,
                    group_id=0XDDAD9CAC
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        photos_ = reader.vector(
            lambda: reader.object(
                group_id=0XDDAD9CAC
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            photos=photos_,
            users=users_
        )

class PhotosSlice(TLObject, family='TypePhotosPhotos'):
    """
    Incomplete list of photos with auxiliary data.
    """

    _id = 0X15051F54
    _group_id = 0X48D204C5

    def __init__(
        self,
        count: int,
        photos: List['TypePhoto'],
        users: List['TypeUser']
    ):

        """
        Incomplete list of photos with auxiliary data.

        Args:
            count (int): Total number of photos
            photos (List['TypePhoto']): List of photos
            users (List['TypeUser']): List of mentioned users
        """

        self.count = count
        self.photos = photos
        self.users = users

    def to_bytes(self, boxed: bool=True):
        with Writer(b'T\x1f\x05\x15' if boxed else b'') as writer:
            writer.int(self.count)
            writer.vector(
                self.photos,
                lambda value: writer.object(
                    value,
                    group_id=0XDDAD9CAC
                )
            )
            writer.vector(
                self.users,
                lambda value: writer.object(
                    value,
                    group_id=0X9BABE43A
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        count_ = reader.int()
        photos_ = reader.vector(
            lambda: reader.object(
                group_id=0XDDAD9CAC
            )
        )

        users_ = reader.vector(
            lambda: reader.object(
                group_id=0X9BABE43A
            )
        )

        return cls(
            count=count_,
            photos=photos_,
            users=users_
        )

TypePhotosPhotos = Union[
    Photos,
    PhotosSlice
]