
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .notification_sound import TypeNotificationSound
    from ...gadgets.byteutils import Reader
    from .reaction_notifications_from import TypeReactionNotificationsFrom


class ReactionsNotifySettings(TLObject, family='TypeReactionsNotifySettings'):
    """
    Reaction notification settings, see [here](https://core.telegram.org/api/reactions#notifications-about-reactions) for more info.
    """

    _id = 0X56E34970
    _group_id = 0X48E71F9E

    def __init__(
        self,
        sound: 'TypeNotificationSound',
        show_previews: bool,
        messages_notify_from: Optional['TypeReactionNotificationsFrom'] = None,
        stories_notify_from: Optional['TypeReactionNotificationsFrom'] = None
    ):

        """
        Reaction notification settings, see [here](https://core.telegram.org/api/reactions#notifications-about-reactions) for more info.

        Args:
            sound ('TypeNotificationSound'): [Notification sound for reactions](https://core.telegram.org/api/ringtones)
            show_previews (bool): If false, [push notifications](https://core.telegram.org/api/push-updates) about message/story reactions will only be of type REACT_HIDDEN/ REACT_STORY_HIDDEN, without any information about the reacted-to story or the reaction itself.
            messages_notify_from (Optional['TypeReactionNotificationsFrom'], optional): Message reaction notification settings, if not set completely disables notifications/updates about message reactions.
            stories_notify_from (Optional['TypeReactionNotificationsFrom'], optional): Story reaction notification settings, if not set completely disables notifications/updates about reactions to stories.
        """

        self.sound = sound
        self.show_previews = show_previews
        self.messages_notify_from = messages_notify_from
        self.stories_notify_from = stories_notify_from

    def to_bytes(self, boxed: bool=True):
        with Writer(b'pI\xe3V' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.messages_notify_from, 0):
                    writer.object(
                        self.messages_notify_from,
                        group_id=0XFBEEF21E
                    )

                if flags(self.stories_notify_from, 1):
                    writer.object(
                        self.stories_notify_from,
                        group_id=0XFBEEF21E
                    )
                writer.object(
                    self.sound,
                    group_id=0X9B633486
                )
                writer.object(
                    self.show_previews,
                    group_id=0X43B904E1
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        messages_notify_from_ = (
            reader.object(
                group_id=0XFBEEF21E
            )
            if flags(0) else None
        )

        stories_notify_from_ = (
            reader.object(
                group_id=0XFBEEF21E
            )
            if flags(1) else None
        )

        sound_ = reader.object(
            group_id=0X9B633486
        )

        show_previews_ = reader.object(
            group_id=0X43B904E1
        )

        return cls(
            sound=sound_,
            show_previews=show_previews_,
            messages_notify_from=messages_notify_from_,
            stories_notify_from=stories_notify_from_
        )

TypeReactionsNotifySettings = ReactionsNotifySettings