
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, Optional, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader
    from .keyboard_button_row import TypeKeyboardButtonRow


class ReplyKeyboardHide(TLObject, family='TypeReplyMarkup'):
    """
    Hide sent bot keyboard
    """

    _id = 0XA03E5B85
    _group_id = 0X146C1631

    def __init__(
        self,
        selective: bool = False
    ):

        """
        Hide sent bot keyboard

        Args:
            selective (bool, optional): Use this flag if you want to remove the keyboard for specific users only. Targets: 1) users that are @mentioned in the text of the Message object; 2) if the bot's message is a reply (has reply_to_message_id), sender of the original message. Example: A user votes in a poll, bot returns confirmation message in reply to the vote and removes the keyboard for that user, while still showing the keyboard with poll options to users who haven't voted yet
        """

        self.selective = selective

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x85[>\xa0' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.selective, 2)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()

        return cls(
            selective=flags(2)
        )

class ReplyKeyboardForceReply(TLObject, family='TypeReplyMarkup'):
    """
    Force the user to send a reply
    """

    _id = 0X86B40B08
    _group_id = 0X146C1631

    def __init__(
        self,
        single_use: bool = False,
        selective: bool = False,
        placeholder: Optional[str] = None
    ):

        """
        Force the user to send a reply

        Args:
            single_use (bool, optional): Requests clients to hide the keyboard as soon as it's been used. The keyboard will still be available, but clients will automatically display the usual letter-keyboard in the chat – the user can press a special button in the input field to see the custom keyboard again.
            selective (bool, optional): Use this parameter if you want to show the keyboard to specific users only. Targets: 1) users that are @mentioned in the text of the Message object; 2) if the bot's message is a reply (has reply_to_message_id), sender of the original message. Example: A user requests to change the bot's language, bot replies to the request with a keyboard to select the new language. Other users in the group don't see the keyboard.
            placeholder (Optional[str], optional): The placeholder to be shown in the input field when the keyboard is active; 1-64 characters.
        """

        self.single_use = single_use
        self.selective = selective
        self.placeholder = placeholder

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x08\x0b\xb4\x86' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.single_use, 1)
                flags(self.selective, 2)

                if flags(self.placeholder, 3):
                    writer.string(self.placeholder)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        placeholder_ = (
            reader.string()
            if flags(3) else None
        )

        return cls(
            single_use=flags(1),
            selective=flags(2),
            placeholder=placeholder_
        )

class ReplyKeyboardMarkup(TLObject, family='TypeReplyMarkup'):
    """
    Bot keyboard
    """

    _id = 0X85DD99D1
    _group_id = 0X146C1631

    def __init__(
        self,
        rows: List['TypeKeyboardButtonRow'],
        resize: bool = False,
        single_use: bool = False,
        selective: bool = False,
        persistent: bool = False,
        placeholder: Optional[str] = None
    ):

        """
        Bot keyboard

        Args:
            rows (List['TypeKeyboardButtonRow']): Button row
            resize (bool, optional): Requests clients to resize the keyboard vertically for optimal fit (e.g., make the keyboard smaller if there are just two rows of buttons). If not set, the custom keyboard is always of the same height as the app's standard keyboard.
            single_use (bool, optional): Requests clients to hide the keyboard as soon as it's been used. The keyboard will still be available, but clients will automatically display the usual letter-keyboard in the chat – the user can press a special button in the input field to see the custom keyboard again.
            selective (bool, optional): Use this parameter if you want to show the keyboard to specific users only. Targets: 1) users that are @mentioned in the text of the Message object; 2) if the bot's message is a reply (has reply_to_message_id), sender of the original message. Example: A user requests to change the bot's language, bot replies to the request with a keyboard to select the new language. Other users in the group don't see the keyboard.
            persistent (bool, optional): Requests clients to always show the keyboard when the regular keyboard is hidden.
            placeholder (Optional[str], optional): The placeholder to be shown in the input field when the keyboard is active; 1-64 characters.
        """

        self.rows = rows
        self.resize = resize
        self.single_use = single_use
        self.selective = selective
        self.persistent = persistent
        self.placeholder = placeholder

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xd1\x99\xdd\x85' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.resize, 0)
                flags(self.single_use, 1)
                flags(self.selective, 2)
                flags(self.persistent, 4)
                writer.vector(
                    self.rows,
                    lambda value: writer.object(
                        value,
                        group_id=0XEDE1E173
                    )
                )

                if flags(self.placeholder, 3):
                    writer.string(self.placeholder)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        rows_ = reader.vector(
            lambda: reader.object(
                group_id=0XEDE1E173
            )
        )

        placeholder_ = (
            reader.string()
            if flags(3) else None
        )

        return cls(
            rows=rows_,
            resize=flags(0),
            single_use=flags(1),
            selective=flags(2),
            persistent=flags(4),
            placeholder=placeholder_
        )

class ReplyInlineMarkup(TLObject, family='TypeReplyMarkup'):
    """
    Bot or inline keyboard
    """

    _id = 0X48A30254
    _group_id = 0X146C1631

    def __init__(
        self,
        rows: List['TypeKeyboardButtonRow']
    ):

        """
        Bot or inline keyboard

        Args:
            rows (List['TypeKeyboardButtonRow']): Bot or inline keyboard rows
        """

        self.rows = rows

    def to_bytes(self, boxed: bool=True):
        with Writer(b'T\x02\xa3H' if boxed else b'') as writer:
            writer.vector(
                self.rows,
                lambda value: writer.object(
                    value,
                    group_id=0XEDE1E173
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        rows_ = reader.vector(
            lambda: reader.object(
                group_id=0XEDE1E173
            )
        )

        return cls(
            rows=rows_
        )

TypeReplyMarkup = Union[
    ReplyKeyboardHide,
    ReplyKeyboardForceReply,
    ReplyKeyboardMarkup,
    ReplyInlineMarkup
]