
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class SecureCredentialsEncrypted(TLObject, family='TypeSecureCredentialsEncrypted'):
    """
    Encrypted credentials required to decrypt [telegram passport](https://core.telegram.org/passport) data.
    """

    _id = 0X33F0EA47
    _group_id = 0X18C0BB4B

    def __init__(
        self,
        data: bytes,
        hash: bytes,
        secret: bytes
    ):

        """
        Encrypted credentials required to decrypt [telegram passport](https://core.telegram.org/passport) data.

        Args:
            data (bytes): Encrypted JSON-serialized data with unique user's payload, data hashes and secrets required for EncryptedPassportElement decryption and authentication, as described in [decrypting data](https://core.telegram.org/passport#decrypting-data)
            hash (bytes): Data hash for data authentication as described in [decrypting data](https://core.telegram.org/passport#decrypting-data)
            secret (bytes): Secret, encrypted with the bot's public RSA key, required for data decryption as described in [decrypting data](https://core.telegram.org/passport#decrypting-data)
        """

        self.data = data
        self.hash = hash
        self.secret = secret

    def to_bytes(self, boxed: bool=True):
        with Writer(b'G\xea\xf03' if boxed else b'') as writer:
            writer.bytes(self.data)
            writer.bytes(self.hash)
            writer.bytes(self.secret)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        data_ = reader.bytes()
        hash_ = reader.bytes()
        secret_ = reader.bytes()

        return cls(
            data=data_,
            hash=hash_,
            secret=secret_
        )

TypeSecureCredentialsEncrypted = SecureCredentialsEncrypted