
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING, List
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from .secure_value_type import TypeSecureValueType
    from ...gadgets.byteutils import Reader


class SecureRequiredType(TLObject, family='TypeSecureRequiredType'):
    """
    Required type
    """

    _id = 0X829D99DA
    _group_id = 0X84707AB2

    def __init__(
        self,
        type: 'TypeSecureValueType',
        native_names: bool = False,
        selfie_required: bool = False,
        translation_required: bool = False
    ):

        """
        Required type

        Args:
            type ('TypeSecureValueType'): Secure value type
            native_names (bool, optional): Native names
            selfie_required (bool, optional): Is a selfie required
            translation_required (bool, optional): Is a translation required
        """

        self.type = type
        self.native_names = native_names
        self.selfie_required = selfie_required
        self.translation_required = translation_required

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xda\x99\x9d\x82' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.native_names, 0)
                flags(self.selfie_required, 1)
                flags(self.translation_required, 2)
                writer.object(
                    self.type,
                    group_id=0X24ADF799
                )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        type_ = reader.object(
            group_id=0X24ADF799
        )

        return cls(
            type=type_,
            native_names=flags(0),
            selfie_required=flags(1),
            translation_required=flags(2)
        )

class SecureRequiredTypeOneOf(TLObject, family='TypeSecureRequiredType'):
    """
    One of
    """

    _id = 0X27477B4
    _group_id = 0X84707AB2

    def __init__(
        self,
        types: List['TypeSecureRequiredType']
    ):

        """
        One of

        Args:
            types (List['TypeSecureRequiredType']): Secure required value types
        """

        self.types = types

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb4wt\x02' if boxed else b'') as writer:
            writer.vector(
                self.types,
                lambda value: writer.object(
                    value,
                    group_id=0X84707AB2
                )
            )

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        types_ = reader.vector(
            lambda: reader.object(
                group_id=0X84707AB2
            )
        )

        return cls(
            types=types_
        )

TypeSecureRequiredType = Union[
    SecureRequiredType,
    SecureRequiredTypeOneOf
]