
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class SmsJob(TLObject, family='TypeSmsJob'):
    """
    Info about an SMS job.
    """

    _id = 0XE6A1EEB8
    _group_id = 0XD44D70C5

    def __init__(
        self,
        job_id: str,
        phone_number: str,
        text: str
    ):

        """
        Info about an SMS job.

        Args:
            job_id (str): Job ID
            phone_number (str): Destination phone number
            text (str): Text
        """

        self.job_id = job_id
        self.phone_number = phone_number
        self.text = text

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xb8\xee\xa1\xe6' if boxed else b'') as writer:
            writer.string(self.job_id)
            writer.string(self.phone_number)
            writer.string(self.text)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        job_id_ = reader.string()
        phone_number_ = reader.string()
        text_ = reader.string()

        return cls(
            job_id=job_id_,
            phone_number=phone_number_,
            text=text_
        )

TypeSmsJob = SmsJob