
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List, TYPE_CHECKING, Optional
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Long, Writer


if TYPE_CHECKING:
    from .photo import TypePhoto
    from .peer_color import TypePeerColor
    from .message_media import TypeMessageMedia
    from .message_entity import TypeMessageEntity
    from ...gadgets.byteutils import Reader


class SponsoredMessage(TLObject, family='TypeSponsoredMessage'):
    """
    A [sponsored message](https://core.telegram.org/api/sponsored-messages).
    """

    _id = 0X7DBF8673
    _group_id = 0X7144FBA5

    def __init__(
        self,
        url: str,
        title: str,
        message: str,
        button_text: str,
        recommended: bool = False,
        can_report: bool = False,
        entities: Optional[List['TypeMessageEntity']] = None,
        photo: Optional['TypePhoto'] = None,
        media: Optional['TypeMessageMedia'] = None,
        color: Optional['TypePeerColor'] = None,
        sponsor_info: Optional[str] = None,
        additional_info: Optional[str] = None,
        min_display_duration: Optional[int] = None,
        max_display_duration: Optional[int] = None,
        random_id: bytes = None
    ):

        """
        A [sponsored message](https://core.telegram.org/api/sponsored-messages).

        Args:
            url (str): Contains the URL to open when the user clicks on the sponsored message.
            title (str): Contains the title of the sponsored message.
            message (str): Sponsored message
            button_text (str): Label of the sponsored message button.
            recommended (bool, optional): Whether the message needs to be labeled as "recommended" instead of "sponsored"
            can_report (bool, optional): Whether this message can be [reported as specified here](https://core.telegram.org/api/sponsored-messages#reporting-sponsored-messages).
            entities (Optional[List['TypeMessageEntity']], optional): [Message entities for styled text](https://core.telegram.org/api/entities) in message.
            photo (Optional['TypePhoto'], optional): If set, contains a custom profile photo bubble that should be displayed for the sponsored message, like for messages sent in groups.
            media (Optional['TypeMessageMedia'], optional): If set, contains some media.
            color (Optional['TypePeerColor'], optional): If set, the sponsored message should use the [message accent color](https://core.telegram.org/api/colors) specified in color.
            sponsor_info (Optional[str], optional): If set, contains additional information about the sponsor to be shown along with the message.
            additional_info (Optional[str], optional): If set, contains additional information about the sponsored message to be shown along with the message.
            min_display_duration (Optional[int], optional): ...
            max_display_duration (Optional[int], optional): ...
            random_id (bytes, optional): Message ID
        """

        self.url = url
        self.title = title
        self.message = message
        self.button_text = button_text
        self.recommended = recommended
        self.can_report = can_report
        self.entities = entities
        self.photo = photo
        self.media = media
        self.color = color
        self.sponsor_info = sponsor_info
        self.additional_info = additional_info
        self.min_display_duration = min_display_duration
        self.max_display_duration = max_display_duration
        self.random_id = Long.to_bytes(Long()) if random_id is None else random_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b's\x86\xbf}' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.recommended, 5)
                flags(self.can_report, 12)
                writer.bytes(self.random_id)
                writer.string(self.url)
                writer.string(self.title)
                writer.string(self.message)

                if flags(self.entities, 1):
                    writer.vector(
                        self.entities,
                        lambda value: writer.object(
                            value,
                            group_id=0X3CDFF38A
                        )
                    )

                if flags(self.photo, 6):
                    writer.object(
                        self.photo,
                        group_id=0XDDAD9CAC
                    )

                if flags(self.media, 14):
                    writer.object(
                        self.media,
                        group_id=0X45F7A020
                    )

                if flags(self.color, 13):
                    writer.object(
                        self.color,
                        group_id=0XA2C08D16
                    )
                writer.string(self.button_text)

                if flags(self.sponsor_info, 7):
                    writer.string(self.sponsor_info)

                if flags(self.additional_info, 8):
                    writer.string(self.additional_info)

                if flags(self.min_display_duration, 15):
                    writer.int(self.min_display_duration)

                if flags(self.max_display_duration, 15):
                    writer.int(self.max_display_duration)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        random_id_ = reader.bytes()
        url_ = reader.string()
        title_ = reader.string()
        message_ = reader.string()
        entities_ = (
            reader.vector(
                lambda: reader.object(
                    group_id=0X3CDFF38A
                )
            )
            if flags(1) else None
        )

        photo_ = (
            reader.object(
                group_id=0XDDAD9CAC
            )
            if flags(6) else None
        )

        media_ = (
            reader.object(
                group_id=0X45F7A020
            )
            if flags(14) else None
        )

        color_ = (
            reader.object(
                group_id=0XA2C08D16
            )
            if flags(13) else None
        )

        button_text_ = reader.string()
        sponsor_info_ = (
            reader.string()
            if flags(7) else None
        )

        additional_info_ = (
            reader.string()
            if flags(8) else None
        )

        min_display_duration_ = (
            reader.int()
            if flags(15) else None
        )

        max_display_duration_ = (
            reader.int()
            if flags(15) else None
        )

        return cls(
            random_id=random_id_,
            url=url_,
            title=title_,
            message=message_,
            button_text=button_text_,
            recommended=flags(5),
            can_report=flags(12),
            entities=entities_,
            photo=photo_,
            media=media_,
            color=color_,
            sponsor_info=sponsor_info_,
            additional_info=additional_info_,
            min_display_duration=min_display_duration_,
            max_display_duration=max_display_duration_
        )

TypeSponsoredMessage = SponsoredMessage