
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Union, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class UserStatusEmpty(TLObject, family='TypeUserStatus'):
    """
    User status has not been set yet.
    """

    _id = 0X9D05049
    _group_id = 0X6F35ECEB


    def to_bytes(self, boxed: bool=True):
        return b'IP\xd0\t' if boxed else b''

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        return cls()

class UserStatusOnline(TLObject, family='TypeUserStatus'):
    """
    Online status of the user.
    """

    _id = 0XEDB93949
    _group_id = 0X6F35ECEB

    def __init__(
        self,
        expires: int
    ):

        """
        Online status of the user.

        Args:
            expires (int): Time to expiration of the current online status
        """

        self.expires = expires

    def to_bytes(self, boxed: bool=True):
        with Writer(b'I9\xb9\xed' if boxed else b'') as writer:
            writer.int(self.expires)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        expires_ = reader.int()

        return cls(
            expires=expires_
        )

class UserStatusOffline(TLObject, family='TypeUserStatus'):
    """
    The user's offline status.
    """

    _id = 0X8C703F
    _group_id = 0X6F35ECEB

    def __init__(
        self,
        was_online: int
    ):

        """
        The user's offline status.

        Args:
            was_online (int): Time the user was last seen online
        """

        self.was_online = was_online

    def to_bytes(self, boxed: bool=True):
        with Writer(b'?p\x8c\x00' if boxed else b'') as writer:
            writer.int(self.was_online)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        was_online_ = reader.int()

        return cls(
            was_online=was_online_
        )

class UserStatusRecently(TLObject, family='TypeUserStatus'):
    """
    Online status: last seen recently
    """

    _id = 0X7B197DC8
    _group_id = 0X6F35ECEB

    def __init__(
        self,
        by_me: bool = False
    ):

        """
        Online status: last seen recently

        Args:
            by_me (bool, optional): If set, the exact user status of this user is actually available to us, but to view it we must first purchase a [Premium](https://core.telegram.org/api/premium) subscription, or allow this user to see our exact last online status. See [here](https://core.telegram.org/constructor/privacyKeyStatusTimestamp) for more info.
        """

        self.by_me = by_me

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\xc8}\x19{' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.by_me, 0)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()

        return cls(
            by_me=flags(0)
        )

class UserStatusLastWeek(TLObject, family='TypeUserStatus'):
    """
    Online status: last seen last week
    """

    _id = 0X541A1D1A
    _group_id = 0X6F35ECEB

    def __init__(
        self,
        by_me: bool = False
    ):

        """
        Online status: last seen last week

        Args:
            by_me (bool, optional): If set, the exact user status of this user is actually available to us, but to view it we must first purchase a [Premium](https://core.telegram.org/api/premium) subscription, or allow this user to see our exact last online status. See [here](https://core.telegram.org/constructor/privacyKeyStatusTimestamp) for more info.
        """

        self.by_me = by_me

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1a\x1d\x1aT' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.by_me, 0)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()

        return cls(
            by_me=flags(0)
        )

class UserStatusLastMonth(TLObject, family='TypeUserStatus'):
    """
    Online status: last seen last month
    """

    _id = 0X65899777
    _group_id = 0X6F35ECEB

    def __init__(
        self,
        by_me: bool = False
    ):

        """
        Online status: last seen last month

        Args:
            by_me (bool, optional): If set, the exact user status of this user is actually available to us, but to view it we must first purchase a [Premium](https://core.telegram.org/api/premium) subscription, or allow this user to see our exact last online status. See [here](https://core.telegram.org/constructor/privacyKeyStatusTimestamp) for more info.
        """

        self.by_me = by_me

    def to_bytes(self, boxed: bool=True):
        with Writer(b'w\x97\x89e' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.by_me, 0)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()

        return cls(
            by_me=flags(0)
        )

TypeUserStatus = Union[
    UserStatusEmpty,
    UserStatusOnline,
    UserStatusOffline,
    UserStatusRecently,
    UserStatusLastWeek,
    UserStatusLastMonth
]