
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ...gadgets.tlobject import TLObject
from ...gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...gadgets.byteutils import Reader


class WebViewResultUrl(TLObject, family='TypeWebViewResult'):
    """
    Contains the webview URL with appropriate theme and user info parameters added
    """

    _id = 0X4D22FF98
    _group_id = 0X60754D10

    def __init__(
        self,
        url: str,
        fullsize: bool = False,
        fullscreen: bool = False,
        query_id: Optional[int] = None
    ):

        """
        Contains the webview URL with appropriate theme and user info parameters added

        Args:
            url (str): Webview URL to open
            fullsize (bool, optional): If set, the app must be opened in fullsize mode instead of compact mode.
            fullscreen (bool, optional): If set, the app must be opened in fullscreen
            query_id (Optional[int], optional): Webview session ID (only returned by [inline button mini apps](https://core.telegram.org/api/bots/webapps#inline-button-mini-apps), [menu button mini apps](https://core.telegram.org/api/bots/webapps#menu-button-mini-apps), [attachment menu mini apps](https://core.telegram.org/api/bots/webapps#attachment-menu-mini-apps)).
        """

        self.url = url
        self.fullsize = fullsize
        self.fullscreen = fullscreen
        self.query_id = query_id

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x98\xff"M' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.fullsize, 1)
                flags(self.fullscreen, 2)

                if flags(self.query_id, 0):
                    writer.long(self.query_id)
                writer.string(self.url)

            return writer.getvalue()

    @classmethod
    def from_reader(cls, reader: 'Reader'):
        flags = reader.flag()
        query_id_ = (
            reader.long()
            if flags(0) else None
        )

        url_ = reader.string()

        return cls(
            url=url_,
            fullsize=flags(1),
            fullscreen=flags(2),
            query_id=query_id_
        )

TypeWebViewResult = WebViewResultUrl