from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonDataModel
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkIOCore

class vtkCellGridIOQuery(vtkmodules.vtkCommonDataModel.vtkCellGridQuery):
    attribute_data:'getset_descriptor'
    data:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetAttributeData(self) -> vtknlohmann.json: ...
    def GetData(self) -> vtknlohmann.json: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsSerializing(self) -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridIOQuery': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridIOQuery': ...

class vtkCellGridReader(vtkmodules.vtkCommonExecutionModel.vtkCellGridAlgorithm):
    file_name:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridReader': ...
    def SetFileName(self, _arg:str) -> None: ...

class vtkCellGridWriter(vtkmodules.vtkIOCore.vtkWriter):
    class Format(int): ...
    MessagePack:'Format'
    NumberOfFormats:'Format'
    PlainText:'Format'
    file_format:'getset_descriptor'
    file_name:'getset_descriptor'
    input:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetFileFormat(self) -> 'Format': ...
    def GetFileName(self) -> str: ...
    @overload
    def GetInput(self) -> 'vtkCellGrid': ...
    @overload
    def GetInput(self, port:int) -> 'vtkCellGrid': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCellGridWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCellGridWriter': ...
    def SetFileFormat(self, _arg:'Format') -> None: ...
    def SetFileName(self, _arg:str) -> None: ...

class vtkCompositeCellGridReader(vtkmodules.vtkCommonExecutionModel.vtkReaderAlgorithm):
    cell_attribute_selection:'getset_descriptor'
    cell_type_selection:'getset_descriptor'
    file_name:'getset_descriptor'
    m_time:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCellAttributeSelection(self) -> 'vtkDataArraySelection': ...
    def GetCellTypeSelection(self) -> 'vtkDataArraySelection': ...
    def GetFileName(self) -> str: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCompositeCellGridReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCompositeCellGridReader': ...
    def SetFileName(self, _arg:str) -> None: ...

class vtkDGIOResponder(object):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDGIOResponder': ...
    def Query(self, query:'vtkCellGridIOQuery', cellType:'vtkCellMetadata', caches:'vtkCellGridResponders') -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDGIOResponder': ...

class vtkIOCellGrid(vtkmodules.vtkCommonCore.vtkObject):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkIOCellGrid': ...
    @staticmethod
    def RegisterCellsAndResponders() -> bool: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkIOCellGrid': ...

