from classiq._internals.enum_utils import StrEnum


class QuantumInstructionSet(StrEnum):
    QASM = "qasm"
    QSHARP = "qsharp"
    IONQ = "ionq"

    @classmethod
    def from_suffix(cls, suffix: str) -> "QuantumInstructionSet":
        if suffix == "qasm":
            return QuantumInstructionSet.QASM
        if suffix == "qs":
            return QuantumInstructionSet.QSHARP
        if suffix == "ionq":
            return QuantumInstructionSet.IONQ
        raise ValueError("Illegal suffix")
