# This file is auto generated by `generate_declarations.py`. #AUTOGENERATED

from classiq.interface.model.quantum_function_declaration import (
    QuantumFunctionDeclaration,
)

QFT_STEP = QuantumFunctionDeclaration.parse_raw(
    """{
    "name": "qft_step",
    "param_decls": {
        "num_qbits": {
            "kind": "int"
        }
    },
    "port_declarations": {
        "qbv": {
            "name": "qbv",
            "size": {
                "expr": "num_qbits"
            },
            "direction": "inout"
        }
    },
    "operand_declarations": {},
    "positional_arg_declarations": []
}"""
)

QFT = QuantumFunctionDeclaration.parse_raw(
    """{
    "name": "qft",
    "param_decls": {
        "num_qbits": {
            "kind": "int"
        }
    },
    "port_declarations": {
        "qbv": {
            "name": "qbv",
            "size": {
                "expr": "num_qbits"
            },
            "direction": "inout"
        }
    },
    "operand_declarations": {},
    "positional_arg_declarations": []
}"""
)

QPE = QuantumFunctionDeclaration.parse_raw(
    """{
    "name": "qpe",
    "param_decls": {
        "reg_size": {
            "kind": "int"
        },
        "qpe_reg_size": {
            "kind": "int"
        }
    },
    "port_declarations": {
        "x": {
            "name": "x",
            "size": {
                "expr": "reg_size"
            },
            "direction": "inout"
        },
        "q": {
            "name": "q",
            "size": {
                "expr": "qpe_reg_size"
            },
            "direction": "inout"
        }
    },
    "operand_declarations": {
        "qfunc": {
            "name": "qfunc",
            "port_declarations": {
                "target": {
                    "name": "target",
                    "size": {
                        "expr": "reg_size"
                    },
                    "direction": "inout"
                }
            }
        }
    },
    "positional_arg_declarations": []
}"""
)

SINGLE_PAULI = QuantumFunctionDeclaration.parse_raw(
    """{
    "name": "single_pauli",
    "param_decls": {
        "reg_size": {
            "kind": "int"
        },
        "slope": {
            "kind": "real"
        },
        "offset": {
            "kind": "real"
        }
    },
    "port_declarations": {
        "x": {
            "name": "x",
            "size": {
                "expr": "reg_size"
            },
            "direction": "inout"
        },
        "q": {
            "name": "q",
            "size": {
                "expr": "1"
            },
            "direction": "inout"
        }
    },
    "operand_declarations": {
        "q1_qfunc": {
            "name": "q1_qfunc",
            "param_decls": {
                "theta": {
                    "kind": "real"
                }
            },
            "port_declarations": {
                "target": {
                    "name": "target",
                    "size": {
                        "expr": "1"
                    },
                    "direction": "inout"
                }
            }
        }
    },
    "positional_arg_declarations": []
}"""
)

LINEAR_PAULI_ROTATIONS = QuantumFunctionDeclaration.parse_raw(
    """{
    "name": "linear_pauli_rotations",
    "param_decls": {
        "reg_size": {
            "kind": "int"
        },
        "num_state_qubits": {
            "kind": "int"
        },
        "bases": {
            "kind": "list",
            "element_type": {
                "kind": "pauli"
            }
        },
        "slopes": {
            "kind": "list",
            "element_type": {
                "kind": "real"
            }
        },
        "offsets": {
            "kind": "list",
            "element_type": {
                "kind": "real"
            }
        }
    },
    "port_declarations": {
        "x": {
            "name": "x",
            "size": {
                "expr": "reg_size"
            },
            "direction": "inout"
        },
        "q": {
            "name": "q",
            "size": {
                "expr": "num_state_qubits"
            },
            "direction": "inout"
        }
    },
    "operand_declarations": {},
    "positional_arg_declarations": []
}"""
)

AMPLITUDE_ESTIMATION = QuantumFunctionDeclaration.parse_raw(
    """{
    "name": "amplitude_estimation",
    "param_decls": {
        "num_phase_qubits": {
            "kind": "int"
        },
        "num_unitary_qubits": {
            "kind": "int"
        }
    },
    "port_declarations": {
        "phase_port": {
            "name": "phase_port",
            "size": {
                "expr": "num_phase_qubits"
            },
            "direction": "output"
        },
        "unitary_port": {
            "name": "unitary_port",
            "size": {
                "expr": "num_unitary_qubits"
            },
            "direction": "output"
        }
    },
    "operand_declarations": {
        "sp_op": {
            "name": "sp_op",
            "param_decls": {
                "num_unitary_qubits": {
                    "kind": "int"
                }
            },
            "port_declarations": {
                "spq": {
                    "name": "spq",
                    "size": {
                        "expr": "num_unitary_qubits"
                    },
                    "direction": "inout"
                }
            }
        },
        "oracle_op": {
            "name": "oracle_op",
            "param_decls": {
                "num_unitary_qubits": {
                    "kind": "int"
                }
            },
            "port_declarations": {
                "oq": {
                    "name": "oq",
                    "size": {
                        "expr": "num_unitary_qubits"
                    },
                    "direction": "inout"
                }
            }
        }
    },
    "positional_arg_declarations": []
}"""
)

SIMPLE_ORACLE = QuantumFunctionDeclaration.parse_raw(
    """{
    "name": "simple_oracle",
    "param_decls": {},
    "port_declarations": {
        "target": {
            "name": "target",
            "direction": "inout"
        }
    },
    "operand_declarations": {
        "predicate": {
            "name": "predicate",
            "port_declarations": {
                "vars": {
                    "name": "vars",
                    "size": {
                        "expr": "len(target)"
                    },
                    "direction": "inout"
                },
                "result": {
                    "name": "result",
                    "size": {
                        "expr": "1"
                    },
                    "direction": "inout"
                }
            }
        }
    },
    "positional_arg_declarations": []
}"""
)

GROVER_DIFFUSER = QuantumFunctionDeclaration.parse_raw(
    """{
    "name": "grover_diffuser",
    "param_decls": {
        "num_qubits": {
            "kind": "int"
        }
    },
    "port_declarations": {
        "p": {
            "name": "p",
            "size": {
                "expr": "num_qubits"
            },
            "direction": "inout"
        }
    },
    "operand_declarations": {},
    "positional_arg_declarations": []
}"""
)

GROVER_OPERATOR = QuantumFunctionDeclaration.parse_raw(
    """{
    "name": "grover_operator",
    "param_decls": {
        "num_qubits": {
            "kind": "int"
        }
    },
    "port_declarations": {
        "p": {
            "name": "p",
            "size": {
                "expr": "num_qubits"
            },
            "direction": "inout"
        }
    },
    "operand_declarations": {
        "sp_op": {
            "name": "sp_op",
            "param_decls": {
                "num_qubits": {
                    "kind": "int"
                }
            },
            "port_declarations": {
                "spq": {
                    "name": "spq",
                    "size": {
                        "expr": "num_qubits"
                    },
                    "direction": "inout"
                }
            }
        },
        "oracle_op": {
            "name": "oracle_op",
            "param_decls": {
                "num_qubits": {
                    "kind": "int"
                }
            },
            "port_declarations": {
                "oq": {
                    "name": "oq",
                    "size": {
                        "expr": "num_qubits"
                    },
                    "direction": "inout"
                }
            }
        }
    },
    "positional_arg_declarations": []
}"""
)

UNIFORM_SUPERPOSITION = QuantumFunctionDeclaration.parse_raw(
    """{
    "name": "uniform_superposition",
    "param_decls": {
        "num_qubits": {
            "kind": "int"
        }
    },
    "port_declarations": {
        "q": {
            "name": "q",
            "size": {
                "expr": "num_qubits"
            },
            "direction": "inout"
        }
    },
    "operand_declarations": {},
    "positional_arg_declarations": []
}"""
)

APPLY_TO_ALL = QuantumFunctionDeclaration.parse_raw(
    """{
    "name": "apply_to_all",
    "param_decls": {
        "num_qubits": {
            "kind": "int"
        }
    },
    "port_declarations": {
        "q": {
            "name": "q",
            "size": {
                "expr": "num_qubits"
            },
            "direction": "inout"
        }
    },
    "operand_declarations": {
        "gate_operand": {
            "name": "gate_operand",
            "port_declarations": {
                "target": {
                    "name": "target",
                    "size": {
                        "expr": "1"
                    },
                    "direction": "inout"
                }
            }
        }
    },
    "positional_arg_declarations": []
}"""
)

GROVER_SEARCH = QuantumFunctionDeclaration.parse_raw(
    """{
    "name": "grover_search",
    "param_decls": {
        "num_qubits": {
            "kind": "int"
        },
        "reps": {
            "kind": "int"
        }
    },
    "port_declarations": {
        "gsq": {
            "name": "gsq",
            "size": {
                "expr": "num_qubits"
            },
            "direction": "inout"
        }
    },
    "operand_declarations": {
        "oracle_op": {
            "name": "oracle_op",
            "param_decls": {
                "num_qubits": {
                    "kind": "int"
                }
            },
            "port_declarations": {
                "oq": {
                    "name": "oq",
                    "size": {
                        "expr": "num_qubits"
                    },
                    "direction": "inout"
                }
            }
        }
    },
    "positional_arg_declarations": []
}"""
)

__all__ = [
    "QFT_STEP",
    "QFT",
    "QPE",
    "SINGLE_PAULI",
    "LINEAR_PAULI_ROTATIONS",
    "AMPLITUDE_ESTIMATION",
    "SIMPLE_ORACLE",
    "GROVER_DIFFUSER",
    "GROVER_OPERATOR",
    "UNIFORM_SUPERPOSITION",
    "APPLY_TO_ALL",
    "GROVER_SEARCH",
]
