# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DedicatedVantagePointArgs', 'DedicatedVantagePoint']

@pulumi.input_type
class DedicatedVantagePointArgs:
    def __init__(__self__, *,
                 apm_domain_id: pulumi.Input[builtins.str],
                 display_name: pulumi.Input[builtins.str],
                 dvp_stack_details: pulumi.Input['DedicatedVantagePointDvpStackDetailsArgs'],
                 region: pulumi.Input[builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None):
        """
        The set of arguments for constructing a DedicatedVantagePoint resource.
        :param pulumi.Input[builtins.str] apm_domain_id: (Updatable) The APM domain ID the request is intended for.
        :param pulumi.Input[builtins.str] display_name: Unique dedicated vantage point name that cannot be edited. The name should not contain any confidential information.
        :param pulumi.Input['DedicatedVantagePointDvpStackDetailsArgs'] dvp_stack_details: (Updatable) Details of a Dedicated Vantage Point (DVP) stack in Resource Manager.
        :param pulumi.Input[builtins.str] region: (Updatable) Name of the region.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] status: (Updatable) Status of the dedicated vantage point.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "dvp_stack_details", dvp_stack_details)
        pulumi.set(__self__, "region", region)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) The APM domain ID the request is intended for.
        """
        return pulumi.get(self, "apm_domain_id")

    @apm_domain_id.setter
    def apm_domain_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "apm_domain_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[builtins.str]:
        """
        Unique dedicated vantage point name that cannot be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dvpStackDetails")
    def dvp_stack_details(self) -> pulumi.Input['DedicatedVantagePointDvpStackDetailsArgs']:
        """
        (Updatable) Details of a Dedicated Vantage Point (DVP) stack in Resource Manager.
        """
        return pulumi.get(self, "dvp_stack_details")

    @dvp_stack_details.setter
    def dvp_stack_details(self, value: pulumi.Input['DedicatedVantagePointDvpStackDetailsArgs']):
        pulumi.set(self, "dvp_stack_details", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[builtins.str]:
        """
        (Updatable) Name of the region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Status of the dedicated vantage point.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _DedicatedVantagePointState:
    def __init__(__self__, *,
                 apm_domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dvp_stack_details: Optional[pulumi.Input['DedicatedVantagePointDvpStackDetailsArgs']] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 monitor_status_count_maps: Optional[pulumi.Input[Sequence[pulumi.Input['DedicatedVantagePointMonitorStatusCountMapArgs']]]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 time_created: Optional[pulumi.Input[builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering DedicatedVantagePoint resources.
        :param pulumi.Input[builtins.str] apm_domain_id: (Updatable) The APM domain ID the request is intended for.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: Unique dedicated vantage point name that cannot be edited. The name should not contain any confidential information.
        :param pulumi.Input['DedicatedVantagePointDvpStackDetailsArgs'] dvp_stack_details: (Updatable) Details of a Dedicated Vantage Point (DVP) stack in Resource Manager.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input['DedicatedVantagePointMonitorStatusCountMapArgs']]] monitor_status_count_maps: Details of the monitor count per state. Example: `{ "total" : 5, "enabled" : 3 , "disabled" : 2, "invalid" : 0 }`
        :param pulumi.Input[builtins.str] name: Unique permanent name of the dedicated vantage point. This is the same as the displayName.
        :param pulumi.Input[builtins.str] region: (Updatable) Name of the region.
        :param pulumi.Input[builtins.str] status: (Updatable) Status of the dedicated vantage point.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_created: The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        :param pulumi.Input[builtins.str] time_updated: The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        if apm_domain_id is not None:
            pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if dvp_stack_details is not None:
            pulumi.set(__self__, "dvp_stack_details", dvp_stack_details)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if monitor_status_count_maps is not None:
            pulumi.set(__self__, "monitor_status_count_maps", monitor_status_count_maps)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) The APM domain ID the request is intended for.
        """
        return pulumi.get(self, "apm_domain_id")

    @apm_domain_id.setter
    def apm_domain_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "apm_domain_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique dedicated vantage point name that cannot be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="dvpStackDetails")
    def dvp_stack_details(self) -> Optional[pulumi.Input['DedicatedVantagePointDvpStackDetailsArgs']]:
        """
        (Updatable) Details of a Dedicated Vantage Point (DVP) stack in Resource Manager.
        """
        return pulumi.get(self, "dvp_stack_details")

    @dvp_stack_details.setter
    def dvp_stack_details(self, value: Optional[pulumi.Input['DedicatedVantagePointDvpStackDetailsArgs']]):
        pulumi.set(self, "dvp_stack_details", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="monitorStatusCountMaps")
    def monitor_status_count_maps(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DedicatedVantagePointMonitorStatusCountMapArgs']]]]:
        """
        Details of the monitor count per state. Example: `{ "total" : 5, "enabled" : 3 , "disabled" : 2, "invalid" : 0 }`
        """
        return pulumi.get(self, "monitor_status_count_maps")

    @monitor_status_count_maps.setter
    def monitor_status_count_maps(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DedicatedVantagePointMonitorStatusCountMapArgs']]]]):
        pulumi.set(self, "monitor_status_count_maps", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Unique permanent name of the dedicated vantage point. This is the same as the displayName.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Name of the region.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        (Updatable) Status of the dedicated vantage point.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "time_updated", value)


class DedicatedVantagePoint(pulumi.CustomResource):

    pulumi_type = "oci:ApmSynthetics/dedicatedVantagePoint:DedicatedVantagePoint"

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apm_domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dvp_stack_details: Optional[pulumi.Input[Union['DedicatedVantagePointDvpStackDetailsArgs', 'DedicatedVantagePointDvpStackDetailsArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Dedicated Vantage Point resource in Oracle Cloud Infrastructure APM Availability Monitoring service (aka APM Synthetics Service).

        Registers a new dedicated vantage point.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_dedicated_vantage_point = oci.apm_synthetics.DedicatedVantagePoint("test_dedicated_vantage_point",
            apm_domain_id=test_apm_domain["id"],
            display_name=dedicated_vantage_point_display_name,
            dvp_stack_details={
                "dvp_stack_id": test_stack["id"],
                "dvp_stack_type": dedicated_vantage_point_dvp_stack_details_dvp_stack_type,
                "dvp_stream_id": test_stream["id"],
                "dvp_version": dedicated_vantage_point_dvp_stack_details_dvp_version,
            },
            region=dedicated_vantage_point_region,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            status=dedicated_vantage_point_status)
        ```

        ## Import

        DedicatedVantagePoints can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ApmSynthetics/dedicatedVantagePoint:DedicatedVantagePoint test_dedicated_vantage_point "dedicatedVantagePoints/{dedicatedVantagePointId}/apmDomainId/{apmDomainId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] apm_domain_id: (Updatable) The APM domain ID the request is intended for.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: Unique dedicated vantage point name that cannot be edited. The name should not contain any confidential information.
        :param pulumi.Input[Union['DedicatedVantagePointDvpStackDetailsArgs', 'DedicatedVantagePointDvpStackDetailsArgsDict']] dvp_stack_details: (Updatable) Details of a Dedicated Vantage Point (DVP) stack in Resource Manager.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[builtins.str] region: (Updatable) Name of the region.
        :param pulumi.Input[builtins.str] status: (Updatable) Status of the dedicated vantage point.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DedicatedVantagePointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Dedicated Vantage Point resource in Oracle Cloud Infrastructure APM Availability Monitoring service (aka APM Synthetics Service).

        Registers a new dedicated vantage point.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_dedicated_vantage_point = oci.apm_synthetics.DedicatedVantagePoint("test_dedicated_vantage_point",
            apm_domain_id=test_apm_domain["id"],
            display_name=dedicated_vantage_point_display_name,
            dvp_stack_details={
                "dvp_stack_id": test_stack["id"],
                "dvp_stack_type": dedicated_vantage_point_dvp_stack_details_dvp_stack_type,
                "dvp_stream_id": test_stream["id"],
                "dvp_version": dedicated_vantage_point_dvp_stack_details_dvp_version,
            },
            region=dedicated_vantage_point_region,
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            freeform_tags={
                "bar-key": "value",
            },
            status=dedicated_vantage_point_status)
        ```

        ## Import

        DedicatedVantagePoints can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ApmSynthetics/dedicatedVantagePoint:DedicatedVantagePoint test_dedicated_vantage_point "dedicatedVantagePoints/{dedicatedVantagePointId}/apmDomainId/{apmDomainId}"
        ```

        :param str resource_name: The name of the resource.
        :param DedicatedVantagePointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DedicatedVantagePointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apm_domain_id: Optional[pulumi.Input[builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[builtins.str]] = None,
                 dvp_stack_details: Optional[pulumi.Input[Union['DedicatedVantagePointDvpStackDetailsArgs', 'DedicatedVantagePointDvpStackDetailsArgsDict']]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 region: Optional[pulumi.Input[builtins.str]] = None,
                 status: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DedicatedVantagePointArgs.__new__(DedicatedVantagePointArgs)

            if apm_domain_id is None and not opts.urn:
                raise TypeError("Missing required property 'apm_domain_id'")
            __props__.__dict__["apm_domain_id"] = apm_domain_id
            __props__.__dict__["defined_tags"] = defined_tags
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if dvp_stack_details is None and not opts.urn:
                raise TypeError("Missing required property 'dvp_stack_details'")
            __props__.__dict__["dvp_stack_details"] = dvp_stack_details
            __props__.__dict__["freeform_tags"] = freeform_tags
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["status"] = status
            __props__.__dict__["monitor_status_count_maps"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(DedicatedVantagePoint, __self__).__init__(
            'oci:ApmSynthetics/dedicatedVantagePoint:DedicatedVantagePoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apm_domain_id: Optional[pulumi.Input[builtins.str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[builtins.str]] = None,
            dvp_stack_details: Optional[pulumi.Input[Union['DedicatedVantagePointDvpStackDetailsArgs', 'DedicatedVantagePointDvpStackDetailsArgsDict']]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            monitor_status_count_maps: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DedicatedVantagePointMonitorStatusCountMapArgs', 'DedicatedVantagePointMonitorStatusCountMapArgsDict']]]]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            region: Optional[pulumi.Input[builtins.str]] = None,
            status: Optional[pulumi.Input[builtins.str]] = None,
            time_created: Optional[pulumi.Input[builtins.str]] = None,
            time_updated: Optional[pulumi.Input[builtins.str]] = None) -> 'DedicatedVantagePoint':
        """
        Get an existing DedicatedVantagePoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] apm_domain_id: (Updatable) The APM domain ID the request is intended for.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[builtins.str] display_name: Unique dedicated vantage point name that cannot be edited. The name should not contain any confidential information.
        :param pulumi.Input[Union['DedicatedVantagePointDvpStackDetailsArgs', 'DedicatedVantagePointDvpStackDetailsArgsDict']] dvp_stack_details: (Updatable) Details of a Dedicated Vantage Point (DVP) stack in Resource Manager.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[Sequence[pulumi.Input[Union['DedicatedVantagePointMonitorStatusCountMapArgs', 'DedicatedVantagePointMonitorStatusCountMapArgsDict']]]] monitor_status_count_maps: Details of the monitor count per state. Example: `{ "total" : 5, "enabled" : 3 , "disabled" : 2, "invalid" : 0 }`
        :param pulumi.Input[builtins.str] name: Unique permanent name of the dedicated vantage point. This is the same as the displayName.
        :param pulumi.Input[builtins.str] region: (Updatable) Name of the region.
        :param pulumi.Input[builtins.str] status: (Updatable) Status of the dedicated vantage point.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[builtins.str] time_created: The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        :param pulumi.Input[builtins.str] time_updated: The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DedicatedVantagePointState.__new__(_DedicatedVantagePointState)

        __props__.__dict__["apm_domain_id"] = apm_domain_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["dvp_stack_details"] = dvp_stack_details
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["monitor_status_count_maps"] = monitor_status_count_maps
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return DedicatedVantagePoint(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) The APM domain ID the request is intended for.
        """
        return pulumi.get(self, "apm_domain_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[builtins.str]:
        """
        Unique dedicated vantage point name that cannot be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dvpStackDetails")
    def dvp_stack_details(self) -> pulumi.Output['outputs.DedicatedVantagePointDvpStackDetails']:
        """
        (Updatable) Details of a Dedicated Vantage Point (DVP) stack in Resource Manager.
        """
        return pulumi.get(self, "dvp_stack_details")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="monitorStatusCountMaps")
    def monitor_status_count_maps(self) -> pulumi.Output[Sequence['outputs.DedicatedVantagePointMonitorStatusCountMap']]:
        """
        Details of the monitor count per state. Example: `{ "total" : 5, "enabled" : 3 , "disabled" : 2, "invalid" : 0 }`
        """
        return pulumi.get(self, "monitor_status_count_maps")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        Unique permanent name of the dedicated vantage point. This is the same as the displayName.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Name of the region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[builtins.str]:
        """
        (Updatable) Status of the dedicated vantage point.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[builtins.str]:
        """
        The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[builtins.str]:
        """
        The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")

