# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetTargetAssetResult',
    'AwaitableGetTargetAssetResult',
    'get_target_asset',
    'get_target_asset_output',
]

@pulumi.output_type
class GetTargetAssetResult:
    """
    A collection of values returned by getTargetAsset.
    """
    def __init__(__self__, block_volumes_performance=None, compartment_id=None, compatibility_messages=None, created_resource_id=None, display_name=None, estimated_costs=None, id=None, is_excluded_from_execution=None, lifecycle_details=None, migration_assets=None, migration_plan_id=None, ms_license=None, preferred_shape_type=None, recommended_specs=None, state=None, target_asset_id=None, test_specs=None, time_assessed=None, time_created=None, time_updated=None, type=None, user_specs=None):
        if block_volumes_performance and not isinstance(block_volumes_performance, int):
            raise TypeError("Expected argument 'block_volumes_performance' to be a int")
        pulumi.set(__self__, "block_volumes_performance", block_volumes_performance)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compatibility_messages and not isinstance(compatibility_messages, list):
            raise TypeError("Expected argument 'compatibility_messages' to be a list")
        pulumi.set(__self__, "compatibility_messages", compatibility_messages)
        if created_resource_id and not isinstance(created_resource_id, str):
            raise TypeError("Expected argument 'created_resource_id' to be a str")
        pulumi.set(__self__, "created_resource_id", created_resource_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if estimated_costs and not isinstance(estimated_costs, list):
            raise TypeError("Expected argument 'estimated_costs' to be a list")
        pulumi.set(__self__, "estimated_costs", estimated_costs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_excluded_from_execution and not isinstance(is_excluded_from_execution, bool):
            raise TypeError("Expected argument 'is_excluded_from_execution' to be a bool")
        pulumi.set(__self__, "is_excluded_from_execution", is_excluded_from_execution)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if migration_assets and not isinstance(migration_assets, list):
            raise TypeError("Expected argument 'migration_assets' to be a list")
        pulumi.set(__self__, "migration_assets", migration_assets)
        if migration_plan_id and not isinstance(migration_plan_id, str):
            raise TypeError("Expected argument 'migration_plan_id' to be a str")
        pulumi.set(__self__, "migration_plan_id", migration_plan_id)
        if ms_license and not isinstance(ms_license, str):
            raise TypeError("Expected argument 'ms_license' to be a str")
        pulumi.set(__self__, "ms_license", ms_license)
        if preferred_shape_type and not isinstance(preferred_shape_type, str):
            raise TypeError("Expected argument 'preferred_shape_type' to be a str")
        pulumi.set(__self__, "preferred_shape_type", preferred_shape_type)
        if recommended_specs and not isinstance(recommended_specs, list):
            raise TypeError("Expected argument 'recommended_specs' to be a list")
        pulumi.set(__self__, "recommended_specs", recommended_specs)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_asset_id and not isinstance(target_asset_id, str):
            raise TypeError("Expected argument 'target_asset_id' to be a str")
        pulumi.set(__self__, "target_asset_id", target_asset_id)
        if test_specs and not isinstance(test_specs, list):
            raise TypeError("Expected argument 'test_specs' to be a list")
        pulumi.set(__self__, "test_specs", test_specs)
        if time_assessed and not isinstance(time_assessed, str):
            raise TypeError("Expected argument 'time_assessed' to be a str")
        pulumi.set(__self__, "time_assessed", time_assessed)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if user_specs and not isinstance(user_specs, list):
            raise TypeError("Expected argument 'user_specs' to be a list")
        pulumi.set(__self__, "user_specs", user_specs)

    @property
    @pulumi.getter(name="blockVolumesPerformance")
    def block_volumes_performance(self) -> builtins.int:
        """
        Performance of the block volumes.
        """
        return pulumi.get(self, "block_volumes_performance")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> builtins.str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compatibilityMessages")
    def compatibility_messages(self) -> Sequence['outputs.GetTargetAssetCompatibilityMessageResult']:
        """
        Messages about the compatibility issues.
        """
        return pulumi.get(self, "compatibility_messages")

    @property
    @pulumi.getter(name="createdResourceId")
    def created_resource_id(self) -> builtins.str:
        """
        Created resource identifier
        """
        return pulumi.get(self, "created_resource_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> builtins.str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="estimatedCosts")
    def estimated_costs(self) -> Sequence['outputs.GetTargetAssetEstimatedCostResult']:
        """
        Cost estimation description
        """
        return pulumi.get(self, "estimated_costs")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        Asset ID generated by mirgration service. It is used in the mirgration service pipeline.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isExcludedFromExecution")
    def is_excluded_from_execution(self) -> builtins.bool:
        """
        A boolean indicating whether the asset should be migrated.
        """
        return pulumi.get(self, "is_excluded_from_execution")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> builtins.str:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="migrationAssets")
    def migration_assets(self) -> Sequence['outputs.GetTargetAssetMigrationAssetResult']:
        """
        Description of the migration asset.
        """
        return pulumi.get(self, "migration_assets")

    @property
    @pulumi.getter(name="migrationPlanId")
    def migration_plan_id(self) -> builtins.str:
        """
        OCID of the associated migration plan.
        """
        return pulumi.get(self, "migration_plan_id")

    @property
    @pulumi.getter(name="msLicense")
    def ms_license(self) -> builtins.str:
        """
        Microsoft license for VM configuration.
        """
        return pulumi.get(self, "ms_license")

    @property
    @pulumi.getter(name="preferredShapeType")
    def preferred_shape_type(self) -> builtins.str:
        """
        Preferred VM shape type that you provide.
        """
        return pulumi.get(self, "preferred_shape_type")

    @property
    @pulumi.getter(name="recommendedSpecs")
    def recommended_specs(self) -> Sequence['outputs.GetTargetAssetRecommendedSpecResult']:
        """
        Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        return pulumi.get(self, "recommended_specs")

    @property
    @pulumi.getter
    def state(self) -> builtins.str:
        """
        The current state of the target asset.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetAssetId")
    def target_asset_id(self) -> builtins.str:
        return pulumi.get(self, "target_asset_id")

    @property
    @pulumi.getter(name="testSpecs")
    def test_specs(self) -> Sequence['outputs.GetTargetAssetTestSpecResult']:
        """
        Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        return pulumi.get(self, "test_specs")

    @property
    @pulumi.getter(name="timeAssessed")
    def time_assessed(self) -> builtins.str:
        """
        The time when the assessment was done. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_assessed")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> builtins.str:
        """
        The time when the target asset was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> builtins.str:
        """
        The time when the target asset was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of action to run when the instance is interrupted for eviction.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userSpecs")
    def user_specs(self) -> Sequence['outputs.GetTargetAssetUserSpecResult']:
        """
        Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        return pulumi.get(self, "user_specs")


class AwaitableGetTargetAssetResult(GetTargetAssetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTargetAssetResult(
            block_volumes_performance=self.block_volumes_performance,
            compartment_id=self.compartment_id,
            compatibility_messages=self.compatibility_messages,
            created_resource_id=self.created_resource_id,
            display_name=self.display_name,
            estimated_costs=self.estimated_costs,
            id=self.id,
            is_excluded_from_execution=self.is_excluded_from_execution,
            lifecycle_details=self.lifecycle_details,
            migration_assets=self.migration_assets,
            migration_plan_id=self.migration_plan_id,
            ms_license=self.ms_license,
            preferred_shape_type=self.preferred_shape_type,
            recommended_specs=self.recommended_specs,
            state=self.state,
            target_asset_id=self.target_asset_id,
            test_specs=self.test_specs,
            time_assessed=self.time_assessed,
            time_created=self.time_created,
            time_updated=self.time_updated,
            type=self.type,
            user_specs=self.user_specs)


def get_target_asset(target_asset_id: Optional[builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTargetAssetResult:
    """
    This data source provides details about a specific Target Asset resource in Oracle Cloud Infrastructure Cloud Migrations service.

    Gets a target asset by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_target_asset = oci.CloudMigrations.get_target_asset(target_asset_id=test_target_asset_oci_cloud_migrations_target_asset["id"])
    ```


    :param builtins.str target_asset_id: Unique target asset identifier
    """
    __args__ = dict()
    __args__['targetAssetId'] = target_asset_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:CloudMigrations/getTargetAsset:getTargetAsset', __args__, opts=opts, typ=GetTargetAssetResult).value

    return AwaitableGetTargetAssetResult(
        block_volumes_performance=pulumi.get(__ret__, 'block_volumes_performance'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compatibility_messages=pulumi.get(__ret__, 'compatibility_messages'),
        created_resource_id=pulumi.get(__ret__, 'created_resource_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        estimated_costs=pulumi.get(__ret__, 'estimated_costs'),
        id=pulumi.get(__ret__, 'id'),
        is_excluded_from_execution=pulumi.get(__ret__, 'is_excluded_from_execution'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        migration_assets=pulumi.get(__ret__, 'migration_assets'),
        migration_plan_id=pulumi.get(__ret__, 'migration_plan_id'),
        ms_license=pulumi.get(__ret__, 'ms_license'),
        preferred_shape_type=pulumi.get(__ret__, 'preferred_shape_type'),
        recommended_specs=pulumi.get(__ret__, 'recommended_specs'),
        state=pulumi.get(__ret__, 'state'),
        target_asset_id=pulumi.get(__ret__, 'target_asset_id'),
        test_specs=pulumi.get(__ret__, 'test_specs'),
        time_assessed=pulumi.get(__ret__, 'time_assessed'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'),
        user_specs=pulumi.get(__ret__, 'user_specs'))
def get_target_asset_output(target_asset_id: Optional[pulumi.Input[builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTargetAssetResult]:
    """
    This data source provides details about a specific Target Asset resource in Oracle Cloud Infrastructure Cloud Migrations service.

    Gets a target asset by identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_target_asset = oci.CloudMigrations.get_target_asset(target_asset_id=test_target_asset_oci_cloud_migrations_target_asset["id"])
    ```


    :param builtins.str target_asset_id: Unique target asset identifier
    """
    __args__ = dict()
    __args__['targetAssetId'] = target_asset_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:CloudMigrations/getTargetAsset:getTargetAsset', __args__, opts=opts, typ=GetTargetAssetResult)
    return __ret__.apply(lambda __response__: GetTargetAssetResult(
        block_volumes_performance=pulumi.get(__response__, 'block_volumes_performance'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compatibility_messages=pulumi.get(__response__, 'compatibility_messages'),
        created_resource_id=pulumi.get(__response__, 'created_resource_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        estimated_costs=pulumi.get(__response__, 'estimated_costs'),
        id=pulumi.get(__response__, 'id'),
        is_excluded_from_execution=pulumi.get(__response__, 'is_excluded_from_execution'),
        lifecycle_details=pulumi.get(__response__, 'lifecycle_details'),
        migration_assets=pulumi.get(__response__, 'migration_assets'),
        migration_plan_id=pulumi.get(__response__, 'migration_plan_id'),
        ms_license=pulumi.get(__response__, 'ms_license'),
        preferred_shape_type=pulumi.get(__response__, 'preferred_shape_type'),
        recommended_specs=pulumi.get(__response__, 'recommended_specs'),
        state=pulumi.get(__response__, 'state'),
        target_asset_id=pulumi.get(__response__, 'target_asset_id'),
        test_specs=pulumi.get(__response__, 'test_specs'),
        time_assessed=pulumi.get(__response__, 'time_assessed'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        type=pulumi.get(__response__, 'type'),
        user_specs=pulumi.get(__response__, 'user_specs')))
